import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form, AmosAlert, Input } from 'amos-framework';
import { hazardSourceClassifySaveAction } from '../../../../../services/bizService';

const FormItem = Form.Item;
const TextArea = Input.TextArea;

/**
 * 危险源类别新增及编辑
 */
class DangerSourceClassifyModel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: [],
      evaModelData: [],
      form: {
        type: '',
        name: '',
        describe: ''
      },
      rules: {
        type: [{ required: true, message: '危险源类别不能为空' },{ max: 30, message: '长度不能大于30个字符',}],
        name: [{ required: true, message: '类别名称不能为空' },{ max: 30, message: '长度不能大于30个字符',}],
        describe: [{ required: true, message: '类别详情不能为空' },{ max: 200, message: '长度不能大于200个字符',}]
      }
    };
  }

  componentWillMount = () => {
    const { selectRowData } = this.props || {};
    if (selectRowData) {
      this.setState({ form: selectRowData });
    }
  };

  onSelectChange = (key, value) => {
    const { form } = this.state;
    form[key] = value;
    this.setState({ form });
  };

  handleSubmit = e => {
    this.form.validate((valid, dataValues) => {
      if (valid) {
        let { form } = this.state;
        this.hazardSourceClassifySave(form);
      } else {
        return false;
      }
    });
  };

  hazardSourceClassifySave = body => {
    hazardSourceClassifySaveAction(body).then(
      data => {
        AmosAlert.success('提示', '操作成功');
        this.props.reloadPage();
      },
      err => {
        AmosAlert.error('提示', err);
      }
    );
  };

  render() {
    const { form, rules } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 7 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };

    return (
      <div>
        <Form model={form} rules={rules} ref={component => this.form = component}>
          <FormItem label={<span>危险源类别</span>} field="type" {...formItemLayout}>
            <Input className="risk_factor_input" required value={form.type} onChange={e => this.onSelectChange('type', e.target.value)} />
          </FormItem>
          <FormItem label={<span>类别名称</span>} field="name" {...formItemLayout}>
            <Input className="risk_factor_input" required value={form.name} onChange={e => this.onSelectChange('name', e.target.value)} />
          </FormItem>
          <FormItem label={<span>类别详情</span>} field="describe" {...formItemLayout}>
            <TextArea rows={10} cols={20} className="risk_factor_input" value={form.describe} onChange={e => this.onSelectChange('describe', e.target.value)} />
          </FormItem>
        </Form>
      </div>
    );
  }
}

DangerSourceClassifyModel.propTypes = {
  reloadPage: PropTypes.func
};
export default DangerSourceClassifyModel;
