import React, { Component } from 'react';
import { Input, Button } from 'amos-framework';
import  PropTypes from 'prop-types';
import IdentityMethodSearch from './identifyMethod/IdentityMethodSearch';
import EvaluationModelSearch from './evaluationModel/EvaluationModelSearch';
import RiskLevelSearch from './riskLevel/RiskLevelSearch';
import EvaluationCriteriaSearch from './evaluationCriteria/EvaluationCriteriaSearch';

class SearchView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      activeKey: ''
    };
  }

  componentDidMount() {}

  onClick = () => {
    const { search } = this.props;
    search && this.search && search(this.search.state.form);
  }

  getRenderContent = (activeKey) => {
    if (activeKey === '1') {
      return <IdentityMethodSearch ref={node => this.search = node} />;
    } else if (activeKey === '2') {
      return <EvaluationModelSearch ref={node => this.search = node} />;
    } else if (activeKey === '3') {
      return <RiskLevelSearch ref={node => this.search = node} />;
    } else if (activeKey === '4') {
      return <EvaluationCriteriaSearch ref={node => this.search = node} />;
    }
  }

  render() {
    let { activeKey } = this.props;

    return (
      <div className='search-view'>
        {this.getRenderContent(activeKey)}
        <div style={{ textAlign: 'center' }}>
          <Button onClick={() => this.onClick()}  style={{ background: '#19afff' }}>查询</Button>
        </div>
      </div>
    );
  }
}

SearchView.propTypes = {
  activeKey: PropTypes.string,
  search: PropTypes.func
};
export default SearchView;
