import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row, Col } from 'amos-framework';
import classNames from 'classnames';
import Diamond from './Diamond';

/**
 * 执行情况行内元素
 *
 * @class ExecuteLineItem
 * @extends {Component}
 */
class ExecuteLineItem extends Component {
  constructor(props) {
    super(props);

  }

  componentWillMount() {

  }

  componentDidMount() {

  }

  renderPoint =({ pointData = [] })=>{
    
    if(pointData!=null){
      return pointData.map(item =>{
        return <Diamond key={item.id} data={item} />;
      });
    }
    
  }

  renderStatusCount =(data)=>{
    return (data || []).map(e=>{
      const cls = classNames({
        'status-item': true,
        [`point-status_${e.status}`]: true
      });
      return (<div key={e.id}  style={{ display: 'inline-block' }}>
        <span>{e.countTypeName} ：</span>
        <span className={cls}>{e.countTypeNumber} &nbsp;&nbsp;</span>
      </div>);
    });
  }

  render() {
    const { lineData = {} } =  this.props;
    return (
      <div className="execute-line-item">
        <Row className='execute-line-item-row row-1'>
          <Col className='execute-line-item-col' span={6}  title={lineData.userName || ''} >{lineData.userName}</Col>
          <Col className='execute-line-item-col' span={10} title={lineData.planName || ''}>{lineData.planName}</Col>
          <Col className='execute-line-item-col' span={8}  title={lineData.deptName || ''}>{lineData.deptName}</Col>
        </Row>
        <Row className='execute-line-item-row row-2'>
          <Col span={24} className='execute-line-item-col-2'>{this.renderStatusCount(lineData.statusCount)}</Col>
        </Row>
        <div className='execute-line-item-row-3'>
          {this.renderPoint(lineData)}
        </div>
      </div>
    );
  }
}

ExecuteLineItem.propTypes = {
  lineData: PropTypes.object
};

export default ExecuteLineItem;
