import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';
import { getInherentIndexDataAction } from './../../../../services/situationService';
import BizIcon from '../../../../view/common/icon/BizIcon';

/**
 * 固有风险指数统计
 * @class InherentRiskIndexPie
 * @extends {Component}
 */
class InherentRiskIndexPie extends Component {
  constructor(props) {
    super(props);
    this.state = {
      monthData: { type0Rate: '16%', countOfType0: 0 },
      seasonData: { type0Rate: '21%', countOfType0: 0 },
      yearData: { type0Rate: '46%', countOfType0: 0 }
    };
  }

  componentWillMount() {
    this.getRiskRiseUpdate();
  }

  componentWillReceiveProps(nextProps) {
    if (!nextProps.refreshData) {
      return;
    } else {
      let { content } = nextProps.refreshData;
      if (content && content === 'riskValue') {
        this.getRiskRiseUpdate();
      }
    }
  }

  getRiskRiseUpdate() {
    getInherentIndexDataAction().then(
      data => {
        console.log('riskValue sucdess');
        let { monthData, seasonData, yearData } = this.state;
        monthData = data.month;
        seasonData = data.season;
        yearData = data.year;
        this.setState({
          monthData,
          seasonData,
          yearData
        });
      }
    );
  }

  getMonthOptions(value, obj) {
    let data = [];
    let color = 'lightgray';
    let data1 = {};
    let data2 = {};
    if (obj) {
      if (value === 'month') {
        data1.name = obj.type0Rate + '\r\n' + '本月风险' + '\r\n' + '上升率';
        color = '#3aa0fe';
      } else if (value === 'season') {
        data1.name = obj.type0Rate + '\r\n' + '本季度风险' + '\r\n' + '上升率';
        color = '#68d288';
      } else if (value === 'year') {
        data1.name = obj.type0Rate + '\r\n' + '本年风险' + '\r\n' + '上升率';
        color = '#fad955';
      }
      //测试数据
      // obj.countOfType0 = 16;
      // obj.countOfSource = 100;

      data1.value = obj.countOfType0;
      data2.value = obj.countOfSource - obj.countOfType0;
      data2.name = '';
      data.push(data1);
      data.push(data2);
    }
    let colors = [];
    colors.push(color);
    colors.push('lightgray');
    return {
      // tooltip: {
      //   align: 'center',
      //   trigger: 'item',
      //   formatter: '{a} <br/>{b}: {c} ({d}%)'
      // },
      color: colors,
      series: [
        {
          name: '风险率',
          type: 'pie',
          radius: ['50%', '70%'],
          avoidLabelOverlap: false,
          label: {
            normal: {
              show: true,
              color: 'black',
              position: 'center',
              formatter: '{b}',
              fontSize: 16
            }
          },
          labelLine: {
            normal: {
              show: false
            }
          },
          data
        }
      ]
    };
  }

  getSeasonOptions(value, obj) {
    let data = [];
    let color = 'lightgray';
    let data1 = {};
    let data2 = {};
    if (obj) {
      if (value === 'month') {
        data1.name = obj.type0Rate + '\r\n' + '本月风险' + '\r\n' + '上升率';
        color = '#3aa0fe';
      } else if (value === 'season') {
        data1.name = obj.type0Rate + '\r\n' + '本季度风险' + '\r\n' + '上升率';
        color = '#68d288';
      } else if (value === 'year') {
        data1.name = obj.type0Rate + '\r\n' + '本年风险' + '\r\n' + '上升率';
        color = '#fad955';
      }
      //测试数据
      // obj.countOfType0 = 21;
      // obj.countOfSource = 100;

      data1.value = obj.countOfType0;
      data2.value = obj.countOfSource - obj.countOfType0;
      data2.name = '';
      data.push(data1);
      data.push(data2);
    }
    let colors = [];
    colors.push(color);
    colors.push('lightgray');
    return {
      // tooltip: {
      //   align: 'center',
      //   trigger: 'item',
      //   formatter: '{a} <br/>{b}: {c} ({d}%)'
      // },
      color: colors,
      series: [
        {
          name: '风险率',
          type: 'pie',
          radius: ['50%', '70%'],
          avoidLabelOverlap: false,
          label: {
            normal: {
              show: true,
              color: 'black',
              position: 'center',
              formatter: '{b}',
              fontSize: 16
            }
          },
          labelLine: {
            normal: {
              show: false
            }
          },
          data
        }
      ]
    };
  }

  getYearOptions(value, obj) {
    let data = [];
    let color = 'lightgray';
    let data1 = {};
    let data2 = {};
    if (obj) {
      if (value === 'month') {
        data1.name = obj.type0Rate + '\r\n' + '本月风险' + '\r\n' + '上升率';
        color = '#3aa0fe';
      } else if (value === 'season') {
        data1.name = obj.type0Rate + '\r\n' + '本季度风险' + '\r\n' + '上升率';
        color = '#68d288';
      } else if (value === 'year') {
        data1.name = obj.type0Rate + '\r\n' + '本年风险' + '\r\n' + '上升率';
        color = '#fad955';
      }
      //测试数据
      // obj.countOfType0 = 46;
      // obj.countOfSource = 100;

      data1.value = obj.countOfType0;
      data2.value = obj.countOfSource - obj.countOfType0;
      data2.name = '';
      data.push(data1);
      data.push(data2);
    }
    let colors = [];
    colors.push(color);
    colors.push('lightgray');
    return {
      // tooltip: {
      //   align: 'center',
      //   trigger: 'item',
      //   formatter: '{a} <br/>{b}: {c} ({d}%)'
      // },
      color: colors,
      series: [
        {
          name: '风险率',
          type: 'pie',
          radius: ['50%', '70%'],
          avoidLabelOverlap: false,
          label: {
            normal: {
              show: true,
              color: 'black',
              position: 'center',
              formatter: '{b}',
              fontSize: 16
            }
          },
          labelLine: {
            normal: {
              show: false
            }
          },
          data
        }
      ]
    };
  }

  render() {
    let { monthData, seasonData, yearData } = this.state;
    let monthOption = this.getMonthOptions('month', monthData);
    let seasonOption = this.getSeasonOptions('season', seasonData);
    let yearOption = this.getYearOptions('year', yearData);
    return (
      <div className="risk-degree-pie">
        <div className="title">
          <BizIcon icon='mokuaidian' className='check-execute-header-icon' />
          <span>固有风险指数仪表盘</span>
        </div>
        <div className="risk-degree-pie1">
          <AmosEcharts option={monthOption} />
          <span>本月风险上升率 |  {monthData.type0Rate}   {monthData.countOfType0}个</span>
        </div>
        <div className="risk-degree-pie2">
          <AmosEcharts option={seasonOption} />
          <span>本季度风险上升率 |  {seasonData.type0Rate}   {seasonData.countOfType0}个</span>
        </div>
        <div className="risk-degree-pie3">
          <AmosEcharts option={yearOption} />
          <span>本年风险上升率 |  {yearData.type0Rate}   {yearData.countOfType0}个</span>
        </div>
      </div>
    );
  }
}

InherentRiskIndexPie.propTypes = {
  refreshData: PropTypes.object
};

InherentRiskIndexPie.defaultProps = {
  data: {}
};

export default InherentRiskIndexPie;
