import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';
import BizIcon from '../../../../view/common/icon/BizIcon';
import { getRiskDataByDeptAction } from './../../../../services/situationService';

class RiskStatisticsHistogram extends Component {
  constructor(props) {
    super(props);
    this.state = {
      seriesData: []
    };
  }

  componentDidMount() {
    this.getRiskStatisticsData();
  }

  componentWillReceiveProps(nextProps) {
    if (!nextProps.refreshData) {
      return;
    } else {
      let { content } = nextProps.refreshData;
      if (content && content === 'riskSource') {
        this.getRiskStatisticsData();
      }
    }
  }

  getRiskStatisticsData = () => {
    getRiskDataByDeptAction().then(data => {
      console.log('riskSource sucdess');
      this.setState({ seriesData: data });
    });
  }

  getOptions = (obj) => {
    obj && obj.series && obj.series.map(item => {
      item.barWidth = 10;
      // item.label && delete item.label;
    });
    return {
      tooltip: {
        trigger: 'axis',
        axisPointer: {
          // 坐标轴指示器，坐标轴触发有效
          type: 'shadow' // 默认为直线，可选为：'line' | 'shadow'
        }
      },
      grid: {
        left: '3%',
        right: '4%',
        bottom: '5%',
        top: '7%',
        containLabel: true
      },
      yAxis: {
        type: 'value',
        axisTick: {
          show: false
        },
        axisLine: {
          show: false
        },
        splitLine: {
          show: true,
          lineStyle: {
            type: 'dashed'
          }
        }
      },
      xAxis: {
        type: 'category',
        axisTick: {
          show: false
        },
        axisLine: {
          lineStyle: {
            color: '#eaeaea'
          }
        },
        axisLabel: {//标签垂直显示
          interval: 0,
          textStyle: {
            color: '#666666'
          }//,
          // formatter: (value) => {
          //   return value.split('').join('\n');
          // }
        },
        data: (obj && obj.xAxisData) || []
      },
      color: ['#f16060', '#ffcc33', '#ffff00', '#00ccff'],
      series: (obj && obj.series) || []
      // series: seriesData
    };
  };

  render() {
    let { seriesData } = this.state;
    return (
      <div className="risk-statistics-histogram">
        <div className="title">
          <BizIcon icon='mokuaidian' className='check-execute-header-icon' />
          <span>风险按车间/部门统计</span>
        </div>
        <AmosEcharts option={this.getOptions(seriesData)} />
      </div>
    );
  }
}

RiskStatisticsHistogram.propTypes = {
  refreshData: PropTypes.object
};

export default RiskStatisticsHistogram;
