import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosWebSocket from 'amos-websocket';
import CheckExecute  from './CheckExecute';
import DynamicRiskIndexPie from './DynamicRiskIndexPie';
import InherentRiskIndexPie from './InherentRiskIndexPie';
import OverdueStatisticsPie from './OverdueStatisticsPie';
import RiskStatisticsHistogram from './RiskStatisticsHistogram';
import DangerStatisticsHistogram from './DangerStatisticsHistogram';
import SysWsURL, { completeToken } from './../../../../consts/wsUrlConsts';
import IndexTrendCurve from './IndexTrendCurve';

const wsURL = SysWsURL.situationws;
// const wsURL = completeToken(SysWsURL.situationws);

/**
 * 安全预控态势
 */
class PreControlSituation extends Component {
  constructor(props) {
    super(props);
    this.state = {
      refreshData: null
    };
  }

  handleData = data => {
    this.setState({ refreshData: data });
  }

  render() {
    const { refreshData } = this.state;
    return (
      <div style={{ overflow: 'auto', height: '100%' }} >
        <AmosWebSocket ref={node => this.aws = node} url={wsURL} onMessage={this.handleData} reconnect debug />
        <div className="pre-control-situation" >
          <div className="left-child" >
            <div className="top-child" >
              <div className="index-trend-map" >
                <IndexTrendCurve />
              </div>
              <div className="risk-statistics" >
                <div className="risk" >
                  <RiskStatisticsHistogram refreshData={refreshData} />
                </div>
                <div className="danger" >
                  <DangerStatisticsHistogram refreshData={refreshData} />
                </div>
              </div>
            </div>
            <div className="bottom-child" >
              <div className="risk-index-dashboard" >
                <div className="inherent-view">
                  <InherentRiskIndexPie refreshData={refreshData} />
                </div>
                <div className="dynamic-view">
                  <DynamicRiskIndexPie refreshData={refreshData} />
                </div>
              </div>
              <div className="overdue-statistics" >
                <OverdueStatisticsPie refreshData={refreshData} />
              </div>
            </div>
          </div>
          <div className="right-child" >
            <CheckExecute refreshData={refreshData} />
          </div>
        </div>
      </div>
    );
  }
}

PreControlSituation.propTypes = {

};

export default PreControlSituation;
