import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';
import AmosWebSocket from 'amos-websocket';
import { Connect } from 'amos-framework';
import { queryRiskSourceRpnCountAction } from './../../../../services/situationService';
import SysWsURL, { completeToken } from './../../../../consts/wsUrlConsts';

const eventConnect = Connect.eventConnect;
const labelOption = {
  normal: {
    show: true,
    position: 'right',
    distance: 5,
    align: 'left',
    formatter: '{c}',
    color: 'black'
  }
};

/**
 * 风险度(RPN) TOP10
 *
 * @class RiskDegreeHistogram
 * @extends {Component}
 */
@eventConnect
class RiskDegreeHistogram extends Component {
  constructor(props) {
    super(props);
    this.state = {
      riskNameList: [],
      rpniData: [],
      rpnrData: []
    };
  }

  componentDidMount() {
    this.getBarViewContent();
  }

  componentWillReceiveProps() {
  }

  getBarViewContent() {
    queryRiskSourceRpnCountAction().then(
      data => {
        let riskNameList = [];
        let rpniData = [];
        let rpnrData = [];
        data && data.map(e => {
          riskNameList.push(e.name);
          rpniData.push(e.rpni);
          rpnrData.push(e.rpn);
        });
        this.setState({
          riskNameList: riskNameList.reverse(),
          rpniData: rpniData.reverse(),
          rpnrData: rpnrData.reverse()
        });
      },
      err => {
        console.log(err);
      }
    );
  }

  getOptions() {
    return {
      tooltip: {
        trigger: 'axis',
        axisPointer: {
          type: 'shadow'
        }
      },
      legend: {
        data: [
          {
            name: 'RPNi',
            icon: 'circle'
          },
          {
            name: 'RPNr',
            icon: 'circle'
          }
        ],
        x: 'right',
        top: '20',
        right: '120'
      },
      grid: {
        left: '3%',
        right: '6%',
        bottom: '3%',
        containLabel: true
      },
      xAxis: {
        type: 'value',
        boundaryGap: [0, 0.03]
      },
      yAxis: {
        type: 'category',
        data: this.state.riskNameList
      },
      color: ['#35bf73', '#f16060'],
      series: [
        {
          name: 'RPNi',
          type: 'bar',
          label: labelOption,
          data: this.state.rpniData,
          // barGap: 2
          barWidth: 14
        },
        {
          name: 'RPNr',
          type: 'bar',
          label: labelOption,
          data: this.state.rpnrData,
          barWidth: 14
        }
      ]
    };
  }

  handleData = () => {
    this.getBarViewContent();
  }

  render() {
    const option = this.getOptions();
    const wsURL = completeToken(SysWsURL.rulews);
    return (
      <div className="risk-degree-rpn-histogram">
        <AmosWebSocket ref={node => this.aws = node} url={wsURL} onMessage={this.handleData} reconnect debug />
        <AmosEcharts option={option} />
      </div>
    );
  }
}

RiskDegreeHistogram.propTypes = {};

RiskDegreeHistogram.defaultProps = {
  data: {},
  legend: [],
  chartStyle: { width: '100%', height: '20rem' }
};

export default RiskDegreeHistogram;
