import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';
import { fetchMonthCountChkAction } from './../../../services/checkInfoService';
import moment from 'moment';
/**
 * 年度隐患治理任务趋势（总数）
 * @class YearDangerCount
 * @extends {Component}
 */
class YearDangerCount extends Component {
  constructor(props) {
    super(props);
    this.state = {
      xList: [],
      proData: [],
      actData: [],
      forData: []
    };
  }
  getOptions(xList, yearNumData) {
    return {
      tooltip: {
        trigger: 'axis'
      },
      color: ['#00FFFF'],
      legend: {
        show: false,
        data: [
          {
            name: '隐患总数分布'
          }
        ]
      },
      grid: {
        x: '5%',
        y: '10%',
        y2: '20%',
        x2: '5%'
      },
      xAxis: [
        {
          type: 'category',
          data: xList,
          axisLabel: {
            show: true,
            textStyle: {
              color: '#000000'
            }
          },
          splitLine: {
            lineStyle: {
              color: ['#000000']
            }
          }
        }
      ],
      yAxis: [
        {
          type: 'value',
          axisLabel: {
            textStyle: {
              color: '#000000'
            }
          },
          splitLine: {
            show: true,
            lineStyle: {
              //type:'dashed',
              width: 1,
              color: 'rgba(34, 34, 34, 1)'
            }
          }
        }
      ],
      series: [
        {
          name: '隐患总数分布',
          type: 'bar',
          data: yearNumData,
          itemStyle: {
            normal: {
              lineStyle: {
                color: '#00FFFF'
              },
              label: {
                show: true,
                position: 'top',
                textStyle: {
                  //数值样式
                  fontSize: 16
                }
              }
            }
          }
        }
      ]
    };
  }

  render() {
    let yearData = this.props.yearData;
    let yearNumData = [];
    let xList = [];
    yearData &&
      yearData.map(e => {
        yearNumData.push(e.yearNum);
        xList.push(e.dateMonth);
      });
    const option = this.getOptions(xList, yearNumData);
    return (
      <div className="danger-year-ins">
        <div className="danger-year-ins-title">年度隐患治理任务趋势（总数）</div>
        <AmosEcharts option={option} style={{ 'height': '90%' }} />
      </div>
    );
  }
}

YearDangerCount.propTypes = {};

YearDangerCount.defaultProps = {
  data: {},
  legend: [],
  chartStyle: { width: '100%', height: '20rem' }
};

export default YearDangerCount;
