import React, { Component } from 'react';
import * as api3D from './../../../services/3dService';
import * as apiCommon from './../../../services/commonServices';

const apis = {
  view3d: api3D,
  common: apiCommon
};

/**
 * 通用数据连接层
 * 将后端数据注入到具体的组件
 * @param {object} options
 */
export default function serviceConnect(options = {}) {
  const { action, apiType } = options;
  return WrappedCompoenet => class ApiComs extends Component {

    constructor(props) {
      super(props);
      this.state = {
        dataSource: []
      };
    }

    componentDidMount() {
      const api = apis[apiType];
      api[action] && api[action]().then(d => {
        this.setState({
          dataSource: d
        });
      });
    }

    render() {
      return <WrappedCompoenet {...this.props} dataSource={this.state.dataSource} />;
    }
  };
}
