import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Nav, NavItem, IndexNavItem } from 'amos-framework';

class NavList extends Component {

  renderNavItem = () => {
    const { menus = [], onMenuItemClick } = this.props;
    return menus.map((es, index) => {
      const params = {
        icon: es.icon,
        title: es.permissionName,
        href: es.path
      };

      if (es.isBlank){
        // 打开新页面
        params.blank = es.isBlank;
      }
      const key = es.key || es.id;
      if (index === 0) {
        return <IndexNavItem key={key} onClick={e => onMenuItemClick(es)} {...params} />;
      } else {
        return <NavItem key={key} onClick={e => onMenuItemClick(es)} {...params} />;
      }
    });
  };

  render() {
    // console.log(this.props);
    // debugger;
    return (
      <div className="nav-container">
        <Nav direction="horizontal" href="/">
          {this.renderNavItem()}
        </Nav>
      </div>
    );
  }
}

NavList.propTypes = {
  menus: PropTypes.array,
  onMenuItemClick: PropTypes.func
};

export default NavList;
