import React from 'react';
import PropTypes from 'prop-types';
import { TimeNow } from 'amos-framework';
import Weather from './Weather';

const Tips = props => {
  const { min, address } = props;
  const fmt = min ? 'HH:mm:ss' : 'yyyy年MM月dd日 www HH:mm:ss';
  return (
    <div className="header-tips">
      <TimeNow fmt={fmt} />
      { !min && <Weather address={address} />}
    </div>
  );
};

Tips.propTypes = {
  min: PropTypes.bool,
  address: PropTypes.string
};

export default Tips;
