import React, { Component } from 'react';
import { browserHistory } from 'amos-react-router';
import { utils, Store } from 'amos-tool';
import { Connect } from 'amos-framework';
import PropTypes from 'prop-types';
import { Link } from 'amos-react-router';
import { Menu, Icon } from 'amos-antd';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import * as endConf from 'amos-processor/lib/config/endconf';
import storageConsts, { CONSTS } from './../../consts/storageConsts';
import { secExtUrl } from './../../consts/urlConsts';
import { pathMapping } from './../../routes/customRoutes';
import MainFrame from '../common/mainframe';
import '../../styles/view/mainframe/mainframe.scss';

const enhanceStorage = Connect.enhanceStorage;
const lsTool = Store.lsTool;
const AmosConfig = endConf.AmosConfig;
const loginURI = AmosConfig.httpURI.loginURI;

@enhanceStorage({
  storageItems: storageConsts(CONSTS)
})
class BizFrame extends Component {
  constructor(props) {
    super(props);
    this.state = {
      siderMenusList: [],
      selectedSubMenuKey: ''
    };
  }
  componentDidMount() {
    window.addEventListener('storage', this.onStorage);
  }
  onStorageChange = (data, e) => {
    // debugger;
    const controlData = this.props.read(CONSTS.control);
    controlData && this.handleControlData(JSON.parse(controlData));
    const forwardData = this.props.read(CONSTS.forward);
    console.log('======================>', forwardData);
    forwardData && this.handleForwardData(JSON.parse(forwardData));
    const sideControlData = this.props.read('sideControl');
    console.log('安岸》', sideControlData);
    sideControlData && this.handleSideControlData(JSON.parse(sideControlData));

    const changeRegionData = this.props.read(CONSTS.region_change);
    changeRegionData && this.handleChangeRegionData(JSON.parse(changeRegionData));
  }
  onStorage = e => {
    // debugger;
    if (e.key === 'cityLine') {
      if (e.newValue) {
        console.log(e.newValue)
        browserHistory.push({pathname: '/biz/defaultRoute',state: { cityLine: e.newValue }});
        // browserHistory.push('/biz/defaultRoute')
      }else {
        window.localStorage.removeItem('cityLine');
      }
    }
  }
  
  handleControlData = (controlData) => {
    //处理三维视图中设置菜单中的注销同时关闭业务视图
    if (controlData.control) {
      const { logOut } = controlData.control || {};
      if (logOut) {
        window.close();
        window.localStorage.removeItem('cityLine');
      }
    }
  }
  /**
   * 处理三维地图上各种点的跳转
   */
  handleForwardData = (forwardData) => {
    //处理三维视图中设置菜单中的注销同时关闭业务视图
    if (forwardData.details) {
      const { dialogId, type, detailForw, checkId } = forwardData.details || {};
      if (type === 'patrol') {
        return;
      } else if (type === 'risk') {
        if (detailForw === 'details'){
          browserHistory.push({ pathname: pathMapping.pointInfo, state: { pointDetail: { pointID: dialogId } } });
        } else if (detailForw === 'danger'){
          const { name } = forwardData.details || {};
          browserHistory.push({ pathname: pathMapping.dangerList, state: { point: { id: dialogId, name, normalForward: false } } });
        } else if (detailForw === 'record'){
          browserHistory.push({ pathname: pathMapping.checkRecordList, state: { pointId: dialogId } });
        }
      } else if (type === 'video') {
        return;
      } else if (type === 'person') {
        return;
      } else if (type === 'data') {
        return;
      } else if (type === 'croom') {
        return;
      } else if (type === 'riskSource') {//风险模型
        browserHistory.push({ pathname: pathMapping.riskModel, state: { riskSourceId: dialogId } });
      }
    }
  }

  handleSideControlData = (data) => {

  }

  handleChangeRegionData = (changeRegionData) => {
    if (changeRegionData.refresh) {
      const { refresh } = changeRegionData.refresh || {};
      if (refresh) {
        if (window && !window.closed) {
          lsTool.remove(CONSTS.region_change);
          window.location.reload(true);
        }
      }
    }
  }

  openDefaultPage = menus => {
    // open first url
    if (location.pathname.startsWith('/biz')) {
      const item = menus.filter(e => e.url)[0] || {};
      if (!utils.isEmpty(item)) {
        if (!utils.isEmpty(item.children)) {
          browserHistory.push(item.children[0].url);
        } else if (item.url) {
          browserHistory.push(item.url);
          // this.setState({ siderMenusList: item.children || [] });
        }
      }
    }
  };

  login = () => {
    window.location.href = loginURI;
  }

  getFrameConfig = () => {
    return {
      opSearchMenusUrl: formatUrl(secExtUrl.opSearchMenusUrl),
      defaultLink: '/biz',
      loginLink: this.login
    };
  };

  getSysToolProps = () => {
    return {
      userPic: require('./../../assets/user/normal.png'),
      loginOutUrl: secExtUrl.loginOutUrl,
      userInfoLink: '/main/securityConfig',
      userExtra: true
    };
  };

  render() {
    const frameConfig = this.getFrameConfig();
    const sysToolPorps = this.getSysToolProps();
    const { siderMenusList, selectedSubMenuKey } = this.state;
    return (
      <MainFrame
        {...frameConfig}
        onMenuLoadCompleted={this.openDefaultPage}
        sysToolPorps={sysToolPorps}
        siderMenusList={siderMenusList}
        selectedSubMenuKey={selectedSubMenuKey}
        menuWidth="160px"
        {...this.props}
      />
    );
  }
}

BizFrame.propTypes = {
  read: PropTypes.func
};

export default BizFrame;
