import { Store } from 'amos-tool';
import { CONSTS, getInnerConfig } from './../../consts/storageConsts';
import { getRegion } from './../../utils/cacheUtils';

const lsTool = Store.lsTool;

export const header3dConf = {
 // logoIcon: require('./../../assets/logo/amos-white.png'),
 // minIcon: require('./../../assets/logo/amos-white.png'),
  logoText: '安全预控执行系统',
  isAbsolute: true,
  address: '渭南'
};

export const headerBizConf = {
  onlyNav: true
};

export const is3dView = code => code === '3dview';

/**
 * 触发菜单变化
 * @param {any} data
 */
export const triggerMenuChange = (data) => {
  lsTool.write(CONSTS.menu_change, JSON.stringify(data));
};

export const getAddress = () => {
  let region = getRegion();
  region = JSON.parse(region) || {};
  return region.address;
};
