import React, { Component } from 'react';
import { UUID } from 'amos-tool';
import { Tabs } from 'amos-framework';
import Port from './port';
import Power from './power';
import Alert from './alert';
import BasicInfo from './basicInfo';
import EquipResource from './equipResource';
import './../../styles/view/pamstable/pamstable.scss';



const { TabList, Tab, TabPanel } = Tabs;
class PamsTable extends Component {
  constructor(props) {
    super(props);
    this.state = {
      tableContent: [<BasicInfo key={UUID.uuid('16')} />]
    };
  }

  /**
   *
   *切换页面组建
   */
  controlClik = key => {
    var tableContent = [];
    if ('port' === key) {
      tableContent = [<Port key={UUID.uuid('16')} />];
    } else if ('equipResource' === key) {
      tableContent = [<EquipResource key={UUID.uuid('16')} />];
    } else if ('basicInfo' === key) {
      tableContent = [<BasicInfo key={UUID.uuid('16')} />];
    } else if ('power' === key) {
      tableContent = [<Power key={UUID.uuid('16')} />];
    } else if ('fan' === key) {
      tableContent = [<Power key={UUID.uuid('16')} />];
    } else if ('hardDIsk' === key) {
      tableContent = [<Port key={UUID.uuid('16')} />];
    } else if ('controller' === key) {
      tableContent = [<Port key={UUID.uuid('16')} />];
    } else if ('link' === key) {
      tableContent = [<Port key={UUID.uuid('16')} />];
    } else if ('networkSession' === key) {
      tableContent = [<Port key={UUID.uuid('16')} />];
    } else if ('equipAvailable' === key) {
      tableContent = [<Port key={UUID.uuid('16')} />];
    } else if ('ruotingTable' === key) {
      tableContent = [<Port key={UUID.uuid('16')} />];
    } else if ('forwardingTable' === key) {
      tableContent = [<Port key={UUID.uuid('16')} />];
    } else if ('arp' === key) {
      tableContent = [<Port key={UUID.uuid('16')} />];
    } else if ('alert' === key) {
      tableContent = [<Alert key={UUID.uuid('16')} />];
    } else if ('environtmetParamStatus' === key) {
      tableContent = [<Port key={UUID.uuid('16')} />];
    } else if ('mq' === key) {
      tableContent = [<Port key={UUID.uuid('16')} />];
    }

    this.setState({ tableContent });
  };
  /**
   *渲染页面
   *
   */
  renderContent = () => {
    const { tableContent } = this.state;
    return tableContent;
  };
  render() {
    console.log('this is pams');
    return (
      <div className="pams-class" style={{ position: 'absolute',zIndex: '999' }}>
        <Tabs>
          <TabList>
            <Tab>基础信息</Tab>
            <Tab>设备资源</Tab>
            <Tab>端口</Tab>
            <Tab>电源</Tab>
            <Tab>风扇</Tab>
            <Tab>硬盘</Tab>
            <Tab>控制器</Tab>
            <Tab>链路</Tab>
            <Tab>网络会话</Tab>
            <Tab>设备可用件</Tab>
            <Tab>路由表</Tab>
            <Tab>转发表</Tab>
            <Tab>ARP</Tab>
            <Tab>告警</Tab>
            <Tab>环境参数状态</Tab>
            <Tab>MQ</Tab>
          </TabList>
          <TabPanel><BasicInfo key={UUID.uuid('16')} /></TabPanel>
          <TabPanel><EquipResource key={UUID.uuid('16')} /></TabPanel>
          <TabPanel><Port key={UUID.uuid('16')} /></TabPanel>
          <TabPanel><Power key={UUID.uuid('16')} /></TabPanel>
          <TabPanel></TabPanel>
          <TabPanel></TabPanel>
          <TabPanel></TabPanel>
          <TabPanel></TabPanel>
          <TabPanel></TabPanel>
          <TabPanel></TabPanel>
          <TabPanel></TabPanel>
          <TabPanel></TabPanel>
          <TabPanel></TabPanel>
          <TabPanel><Alert key={UUID.uuid('16')} /></TabPanel>
          <TabPanel></TabPanel>
          <TabPanel></TabPanel>
        </Tabs>
      </div>
    );
  }
}

export default PamsTable;
