import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Checkbox } from 'amos-framework';
import { innateControlImg } from './_markerConsts';

const EvolutionGroup = Checkbox.EvolutionGroup;

const resourceCtls = [
  { key: 'initView', icon: 'good_view', tip: '初始视图' },
  { key: 'picker', icon: 'picker', tip: '坐标拾取' }
];

/**
 * 视图控制区
 *
 * @class BizControlPane
 * @extends {Component}
 */
class InnateControlPane extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selects: ''
    };
  }

  onChange = (selects, item) => {
    this.setState({
      selects
    });
    const checked = !!selects;
    this.props.onItemClick && this.props.onItemClick(item, checked);
  }

  renderItem(item = {}){
    const { key, icon, className, onClick, tip } = item;
    return (
      <div key={key} className={className} onClick={onClick} title={tip}>
        <img className="ctl-item-img" src={innateControlImg[icon]} alt="" />
      </div>
    );
  }

  render() {
    const { selects } = this.state;
    return (
      <EvolutionGroup
        single
        className='innate-control-evo-group'
        vertical
        selects={selects}
        datas={resourceCtls}
        onChange={this.onChange}
        renderItem={this.renderItem}
      />
    );
  }
}

InnateControlPane.propTypes = {
  subscribe: PropTypes.func,
  onItemClick: PropTypes.func,
  handleDesignClick: PropTypes.func
};

export default InnateControlPane;
