import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Paragraph } from 'amos-framework';
import AssistCard from './AssistCard';

class AssistDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  componentWillMount() {
    this.setState({ data: this.props.data });
  }

  componentWillReceiveProps(nextProps) {
    this.setState({ data: nextProps.data });
  }

  renderAssist = (arr) => {
    if (arr && arr.length > 0) {
      return arr.map((item, index) => {
        return (<AssistCard key={item.title} data={item} />);
      });
    }
  }

  render() {
    const { data } = this.state;
    return (
      <div className="assist-content">
        {this.renderAssist(data)}
      </div>
    );
  }
}

AssistDetail.propTypes = {
  data: PropTypes.array,
  contingency: PropTypes.string
};

export default AssistDetail;
