import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import Icon from 'amos-icon';

import imgStatic from './../../../../consts/imgStatic';

const pointIcon = imgStatic.planDetail;

const margin = 8;
const barimgWidth = 105;
const barWidth = barimgWidth + margin;
const leftRightWidth = 25;
const leftRightALLWidth = (leftRightWidth * 2) + margin;

class Carousel extends Component {

  static propTypes = {
    files: PropTypes.array,
    barLength: PropTypes.number
  };

  static defaultProps = {
    files: [],
    barLength: 3
  };

  constructor(props) {
    super(props);
    this.state = {
      activeFile: 1,
      allWidth: 0,
      fillObjs: []
    };
  }

  componentWillMount() {
    this.setState({ files: this.props.files });
    console.log('02组件将要挂载');
  }

  componentDidMount(){
    this.onInit();
    console.log('04组件将要挂载');
  }

  componentWillReceiveProps(nextProps) {
    this.setState({ files: nextProps.files });
    this.onInit();
    console.log('componentWillReceiveProps');
  }

  onInit = () => {
    const { files, allWidth } = this.state;
    if (!files) {
      return;
    }
    let fillObjs = [files[files.length - 1], ...files, files[0]];
    fillObjs = fillObjs.map((e, index) => {
      let value = index;
      if (index === 0) {
        value = files.length;
      }
      if (index === fillObjs.length - 1) {
        value = 1;
      }
      return { key: index, file: e, value };
    });
    if (this.node.clientWidth !== 0) {
      this.setState({ allWidth: this.node.clientWidth, fillObjs, activeFile: 1 });
    } else {
      this.setState({ fillObjs, activeFile: 1 });
    }
  }

  onClick = (file) => {
    this.setState({ activeFile: file });
  }

  onLeftClick = () => {
    const { files } = this.state;
    const { activeFile } = this.state;
    this.setState({ activeFile: (activeFile - 1) > 0 ? activeFile - 1 : files.length });
  }

  onRightClick = () => {
    const { files } = this.state;
    const { activeFile } = this.state;
    this.setState({ activeFile: (activeFile + 1) <= files.length ? activeFile + 1 : 1 });
  }

  render() {
    const { files, barLength } = this.state;
    const { activeFile, allWidth, fillObjs } = this.state;
    if (files.length === 1) {
      return (
        <div ref={node=> this.node = node} className="carousel-content">
          <img className="carousel-img" src={pointIcon[files[0]]} alt="" />
        </div>
      );
    }
    const carouselBarWidth = files.length < barLength ? barWidth * files.length : barWidth * barLength;
    const carouselBarAllWidth = barWidth * fillObjs.length;
    return (
      <div ref={node=> this.node = node} className="carousel-content">
        <ul className="carousel-inner precontrol-detail-assist" style={{ width: `${allWidth * fillObjs.length}px`, left: -allWidth * activeFile }}>
          {
            fillObjs.map(e => (
              <li key={e.key} style={{ width: `${allWidth}px` }} className="carousel-item">
                <img className="carousel-img" src={pointIcon[e.file]} alt="" />
              </li>
            ))
          }
        </ul>
        <div className="carousel-indicators precontrol-carousel-indicators" style={{ left: `calc(50% - ${(carouselBarWidth + leftRightALLWidth) / 2}px)` }}>
          <div className="carousel-left-bar" onClick={this.onLeftClick} style={{ width: `${leftRightWidth}px`, marginRight: `${margin}px` , background: '#00000000' }}>
            <img className="carousel-img" src={pointIcon.left} alt="" />
          </div>
          <div className="carousel-center-bar precontrol-carousel-center-bar" style={{ width: `${carouselBarWidth}px` }}>
            <ul className="carousel-bar" style={{ width: `${carouselBarAllWidth}px`, left: -barWidth * (activeFile - 1) }}>
              {
                fillObjs.map(e => (
                  <li
                    key={e.key}
                    style={{ width: `${barimgWidth}px`, marginRight: `${margin}px` }}
                    onClick={()=>this.onClick(e.value)}
                    className={classnames('carousel-bar-item', { 'active': e.value === activeFile })}
                  >
                    <img className="carousel-img" src={pointIcon[e.file]} alt="" />
                  </li>
                ))
              }
            </ul>
          </div>
          <div className="carousel-right-bar" onClick={this.onRightClick} style={{ width: `${leftRightWidth}px`, marginLeft: `${margin}px` , background: '#00000000' }}>
            <img className="carousel-img" src={pointIcon.right} alt="" />
          </div>
        </div>
      </div>
    );

  }
}

export default Carousel;
