import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { XJBaseURI } from 'CONSTS/urlConsts';
import imgStatic from 'CONSTS/imgStatic';
import Carousel from './Carousel';

const transitionTime = 500;

class Picture extends Component {

  static propTypes = {
    markerData: PropTypes.object
  };

  static defaultProps = {
    markerData: {}
  };

  constructor(props) {
    super(props);
    this.state = {
      carouselVisable: false
    };
  }

  componentWillMount() {
    this.setState({ markerData: this.props.markerData });
  }

  componentDidMount() {
    //Carousel组件中会计算容器宽度，然而此容器是通过css3过渡属性将宽度在0.5秒内慢慢放大，故目前等待0.5秒进行展示
    this.timer = setTimeout(() => {
      this.setState({ carouselVisable: true });
    }, transitionTime);
  }


  componentWillReceiveProps(nextProps) {
    this.setState({ markerData: nextProps.markerData });
  }

  componentWillUnmount() {
    clearTimeout(this.timer);
  }

  render() {
    const { markerData } = this.state;
    let className = markerData.length > 1 ? 'precontrol-point-details-picture' : 'precontrol-point-details-picture1';
    return (
      <div className={className}>
        { markerData.length > 0 && this.state.carouselVisable && <Carousel files={markerData} />}
      </div>
    );
  }
}

export default Picture;
