import formatUrl from 'amos-processor/lib/utils/urlFormat';
import * as helper from 'base-r3d/lib/utils/helper';
// import { helper } from 'amos-3d/lib/threeTools';
import { FscSerUrl, FasSerUrl } from './../consts/urlConsts';
import { commonGet, commonPost, singleFetch } from './../utils/request';
import { baseURI } from 'amos-processor/lib/config/endconf';

//---------------- 加载模型、解析模型json -----------
export const getObjFromNet = (url, callback) => {
  return singleFetch(url).then(data => {
    const objs = helper.parseModelConfig(data);

    // 临时将 asyncModels 也放在主线程
    const { basePath, asyncModels = [] } = data;
    const _asyncModels = asyncModels.map(m => ({
      basePath,
      ...m
    }));

    // const _objs = objs.concat(_asyncModels);
    callback(objs, _asyncModels);
  });
};

//---------------- 三维视图 -----------
/**
 * 获取各个类型的marker
 * @param {string} type
 */
export const initView3DAction = (type) => {
  const url = formatUrl(FscSerUrl.view3dInitUrl, { type });
  return commonGet(url);
};

/**
 * 获取巡检路线
 */
export const initView3DLinkAction = () => {
  return commonGet(FscSerUrl.view3dInitLinkUrl);
};


/**
 * 右侧菜单-检索-区域集合
 */
export const searchRegionListAction = () => {
  return commonGet(FscSerUrl.searchRegionListUrl);
};
/**
 * 右侧菜单-检索
 */
export const searchAction = (inputText, dataLevel, orgCode, nodeState, protectObjName, routeName, type, page, pageSize) => {
  return commonGet(formatUrl(FscSerUrl.searchViewUrl, { inputText, dataLevel, orgCode, nodeState, protectObjName, routeName, type, page, pageSize }));
};

/**
 * 检索 -- 单条巡检线
 */
export const searchLinkAction = (linkId) => {
  return commonGet(formatUrl(FscSerUrl.searchLinkUrl, { linkId }));
};
/**
 * 右侧菜单-监控-区域集合
 */
export const monitorRegionListAction = () => {
  return commonGet(FscSerUrl.monitorRegionListUrl);
};
/**
 * 右侧菜单-监控
 */
export const monitorAction = (filter, page, size) => {
  return commonPost(formatUrl(FscSerUrl.monitorUrl, { page, size }), filter);
};
/**
 * 右侧菜单-记录-状态集合
 */
export const recordStatusListAction = () => {
  return commonGet(FscSerUrl.recordStatusListUrl);
};
/**
 * 右侧菜单-记录
 */
export const recordAction = (filter, page, size) => {
  return commonPost(formatUrl(FscSerUrl.recordUrl, { page, size }), filter);
};
/**
 * 右侧菜单-轨迹-人员集合
 */
export const trajectoryPersonListAction = (type) => {
  return commonGet(formatUrl(FscSerUrl.trajectoryPersonListUrl, { type }));
};
/**
 * 右侧菜单-轨迹
 */
export const trajectoryAction = (filter, page, size) => {
  return commonPost(formatUrl(FscSerUrl.trajectoryUrl, { page, size }), filter);
};
/**
 * 右侧菜单-消息-类别集合
 */
export const msgCategoryListAction = () => {
  return commonGet(FscSerUrl.msgCategoryListUrl);
};
/**
 * 右侧菜单-消息
 */
export const msgAction = (filter, page, size) => {
  return commonPost(formatUrl(FscSerUrl.msgUrl, { page, size }), filter);
};
/**
 * 右侧菜单-播报-类型集合
 */
export const broadcastTypeListAction = () => {
  return commonGet(FscSerUrl.broadcastTypeListUrl);
};
/**
 * 右侧菜单-播报
 */
export const broadcastAction1 = (filter, page, size) => {
  return commonPost(formatUrl(FscSerUrl.broadcastUrl, { page, size }), filter);
};

/**
 * 刷新时间轴
 */
export const broadcastAction = (instanceNo,recordType) => {
  return commonGet(formatUrl(FscSerUrl.broadcastUrl, { instanceNo,recordType }));
};

/**
 * 三维地图中各种点详情
 */
export const markerDetailsAction = (id, type) => {
  return commonGet(formatUrl(FscSerUrl.markerDetailsUrl, { id, type }));
};

export const getImpEquipmentAction = () => {
  return commonGet(FasSerUrl.equipNoPageListUrl);
};

/**
 * 3d屏保数据
 */
export const getScreenSaverDataAction = () => {
  let url = FasSerUrl.screenSaverDataUrl;
  return commonGet(url);
};

/**
 * 获取巡检点详情
 */
export const pointInfoAction = (pointId) => {
  return commonGet(formatUrl(FscSerUrl.pointInfoUrl, { pointId }));
};

//----------------  tile 3d

/**
 * 设备信息
 */
export const tileEquipAction = () => {
  return commonGet(FscSerUrl.tileEquipmentUrl);
};
/**
 * 风险点
 */
export const tileRiskAction = () => {
  return commonGet(FscSerUrl.tileRiskSourceUrl);
};
/**
 * 监控设备
 */
export const tileVideoAction = () => {
  return commonGet(FscSerUrl.tileVideoMonitorUrl);
};

/**
 * tileView类型
 */
export const tileViewTypeAction = () => {
  return commonGet(FscSerUrl.tileViewTypeUrl);
};
/**
 * 根据类型查询
 */
export const tileViewListAction = ( type ) => {
  return commonGet(formatUrl(FscSerUrl.tileViewListUrl, { type }));
};
/**
 * 绑定坐标console.log(data);
 */
export const bindTileViewAction = ( data ) => {
  console.log(data);
  return commonPost( FscSerUrl.bindTileViewUrl , data );
};

/**
 * 右侧菜单-步骤
 */
export const exeRecordAction = (filter, page, size)=>{
  return commonPost(formatUrl(FscSerUrl.stepUrl, { page, size }), filter);
};

/**
 * 查询三维业务统计数据
 * @param {string} markerType 标记点类型
 */
export const query3DStatistics = (markerType) => {
  return commonGet(formatUrl(FasSerUrl.view3DStatisticsUrl, { markerType }));
};

/**
 * 查询设备详情
 * @param {*} id
 */
export const impEquDetail3dAction = (id,type) => {
  return commonGet(formatUrl(FscSerUrl.impEquDetailUrl, { id, type }));
};

/**
 * 查询设备端口列表
 * @param {*} id
 */
export const euqipmentPortInfo3dAction = (id) => {
  return commonGet(formatUrl(FscSerUrl.impEquPortListUrl, { id }));
};

/**
 * 查询设备告警
 * @param {*} id
 */
export const euqipmentWarn3dAction = (sourceId, pageNumber, pageSize) => {
  return commonGet(formatUrl(FscSerUrl.impEquWarnListUrl, { sourceId, pageNumber, pageSize }));
};

/**
 * 查询网络接口
 * @param {*} id
 */
export const impEquInterface3dAction = (id) => {
  return commonGet(formatUrl(FscSerUrl.impEquInterfaceUrl, { id }));
};

/**
 * 查询动环数据
 * @param {*} id
 */
export const dynamicRingData3dAction = (id) => {
  // return commonGet(formatUrl(DeviceURI.dynamicRingDataUrl, { id }));
  return commonGet(formatUrl(FscSerUrl.dynamicRingDataUrl, { id }));
};

export const fetchJsonAction = (url,callBack) => {
  singleFetch(url).then(data => {
    callBack(data);
  });

};


export const getxuncountAction = () => {
  return commonGet(FscSerUrl.getxuncountActionUrl);
};

/**
 * 查询主页右上角接口
 * @param {*} id
 */
export const rightTopChartAction = (companyId) => {
  return commonGet(formatUrl(FscSerUrl.rightTopChartDataUrl,{ companyId }));
};
/**
 * 查询主页一级值班信息
 * @param {*} id
 */
export const middleTabletAction = ( page, size ) => {
  return commonGet(formatUrl(FscSerUrl.middleTableListUrl,{ page, size }));
};
/**
 * 查询主页二级值班信息
 * @param {*} id
 */
export const middleHeaderAction = ( page, size ) => {
  return commonGet(formatUrl(FscSerUrl.middleHeaderDataUrl));
};
/**
 * 查询主页支付累计数据
 * @param {*} id
 */
export const BottomTableAction = ( ) => {
  return commonGet(formatUrl(FscSerUrl.bottomTableDataUrl));
};

export const middleHeaderAction1 = (start, end,depId,deptName ) => {
  return commonGet(formatUrl(FscSerUrl.middleHeaderAction1,{ start, end , depId, deptName }));
};


export const getporintAction = (pointid ) => {
  return commonGet(formatUrl(FscSerUrl.getporintAction,{ pointid }));
};


export const queryPatrolPointDatas = (factorId) => {
  // return commonGet(formatUrl(DeviceURI.dynamicRingDataUrl, { id }));
  return commonGet(formatUrl(FscSerUrl.pointItemPatroltaUrl, { factorId }));
};

export const queryDevicePointDatas = (factorId) => {
  // return commonGet(formatUrl(DeviceURI.dynamicRingDataUrl, { id }));
  return commonGet(formatUrl(FscSerUrl.pointItemDevicetaUrl, { factorId }));
};


export const queryPointItemAllDatas = (factorId) => {
  // return commonGet(formatUrl(DeviceURI.dynamicRingDataUrl, { id }));
  return commonGet(formatUrl(FscSerUrl.pointItemAllUrl, { factorId }));
};
