import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { SpcSerUrl } from './../consts/urlConsts';
import { commonDelete, commonPost, commonGet, commonPut } from './../utils/request';


/**
 * 摄像头查询
 */
export const getCamerasDataAction = (filter, page, size) => {
  return commonPost(formatUrl(SpcSerUrl.camerasListUrl, { page, size }), filter);
};

export const camerasDeleteAction = (ids)=>{
  return commonDelete(formatUrl(SpcSerUrl.camerasDeleteUrl, { ids }));
};

export const camerasSaveAction = (cameras) =>{
  return commonPost(SpcSerUrl.camerasSaveUrl, cameras);
};

export const getCamerasTypeAction = () =>{
  return commonGet(SpcSerUrl.camerasTypeEumUrl);
};


/**
 * 风险辨识方法相关service
 */
export const getIdentificationMethodAction = (filter, page, size) => {
  let url = formatUrl(SpcSerUrl.getIdentificationMethodUrl, { page, size });
  return commonPost(url, filter);
};

export const identificationMethodSaveAction = (idMethod) => {
  let url = formatUrl(SpcSerUrl.identificationMethodSaveUrl);
  if (idMethod.id === undefined) {
    return commonPost(url, idMethod);
  } else {
    return commonPut(url, idMethod);
  }
};

export const identificationMethodDeleteAction = (ids) => {
  let url = formatUrl(SpcSerUrl.identificationMethodSaveUrl);
  return commonDelete(url, ids);
};

/**
 * 风险评价方法相关service
 */
export const getEvaluateModelListAction = (filter, page, size) => {
  let url = formatUrl(SpcSerUrl.getEvaluateModelListUrl, { page, size });
  return commonPost(url, filter);
};

export const evaluateModelDeleteAction = (ids) => {
  let url = formatUrl(SpcSerUrl.evaluateModelDeleteUrl, { ids });
  return commonDelete(url);
};

export const evaluateModelSaveAction = (evalModel) => {
  let url = formatUrl(SpcSerUrl.evaluateModelSaveUrl);
  return commonPost(url, evalModel);
};

/**
 * 风险等级相关service
 */
export const getRiskLevelListAction = (filter, page, size) => {
  let url = formatUrl(SpcSerUrl.getRiskLevelListUrl, { page, size });
  return commonPost(url, filter);
};

export const riskLevelDeleteAction = (ids) => {
  let url = formatUrl(SpcSerUrl.riskLevelDeleteUrl, { ids });
  return commonDelete(url);
};

export const riskLevelSaveAction = (riskLevel) => {
  let url = formatUrl(SpcSerUrl.riskLevelSaveUrl);
  return commonPost(url, riskLevel);
};

/**
 * 风险评价准则相关service
 */
export const getEvaluateCriteriaListAction = (filter, page, size) => {
  let url = formatUrl(SpcSerUrl.getEvaluateCriteriaListUrl, { page, size });
  return commonPost(url, filter);
};

export const evaluateCriteriaDeleteAction = (ids) => {
  let url = formatUrl(SpcSerUrl.evaluateCriteriaDeleteUrl, { ids });
  return commonDelete(url);
};

export const evaluateCriteriaSaveAction = (evaluateCriteria) => {
  let url = formatUrl(SpcSerUrl.evaluateCriteriaSaveUrl);
  return commonPost(url, evaluateCriteria);
};

export const queryHazardSourceClassifyAction = (filter, page, size) => {
  return commonPost(formatUrl(SpcSerUrl.hazardSourceClassifyListUrl, { page, size }), filter);
};

export const hazardSourceClassifySaveAction = (body) =>{
  return commonPost(SpcSerUrl.hazardSourceClassifySaveUrl, body);
};

export const hazardSourceClassifyDeleteAction = (body) =>{
  return commonPost(SpcSerUrl.hazardSourceClassifyDeleteUrl, body);
};

export const querySpcAftermathAction = (filter, page, size) => {
  return commonPost(formatUrl(SpcSerUrl.aftermathListUrl, { page, size }), filter);
};

export const spcAftermathSaveAction = (body) =>{
  return commonPost(SpcSerUrl.aftermathSaveUrl, body);
};

export const spcAftermathDeleteAction = (body) =>{
  return commonPost(SpcSerUrl.aftermathDeleteUrl, body);
};

export const queryControlMeasureAction = (filter, page, size) => {
  return commonPost(formatUrl(SpcSerUrl.controlMeasureListUrl, { page, size }), filter);
};

export const controlMeasureSaveAction = (body) =>{
  return commonPost(SpcSerUrl.controlMeasureSaveUrl, body);
};

export const controlMeasureDeleteAction = (body) =>{
  return commonPost(SpcSerUrl.controlMeasureDeleteUrl, body);
};

export const controlMeasureDetailAction = (id) =>{
  return commonGet(formatUrl(SpcSerUrl.controlMeasureDetailUrl, { id }));
};

export const deleteMeasureContentAction = (id) => {
  return commonDelete(formatUrl(SpcSerUrl.measureContentDeleteUrl, { id }));
};

export const getCatalogEumAction = (id) =>{
  return commonGet(SpcSerUrl.catalogEumUrl);
};

export const getTypeEumAction = (id) =>{
  return commonGet(SpcSerUrl.typeEumUrl);
};

/*** 风险辨识与评价BEGIN*/
export const queryRiskSourceTreeAction = () => {
  return commonGet(formatUrl(SpcSerUrl.riskSourceTreeUrl), {});
};

export const queryRiskLevelEumListAction = () => {
  return commonGet(SpcSerUrl.riskLevelEumListUrl);
};

export const queryRiskLevelListByEvModelAction = (evModelId) => {
  let url = formatUrl(SpcSerUrl.evaluateModelRiskLeveListUrl, { evModelId });
  return commonGet(url);
};

export const riskSourceSaveAction = (body) => {
  return commonPost(formatUrl(SpcSerUrl.riskSourceSaveUrl), body);
};

export const riskSourceDeleteAction = (ids) => {
  return commonDelete(formatUrl(SpcSerUrl.riskSourceDeleteUrl,{ ids }));
};

export const dangerFactorListAction = (filter, page, size) => {//查询危险因素
  return commonPost(formatUrl(SpcSerUrl.dangerFactorPageListUrl, { page, size }), filter);
};

export const queryRiskSourceDetailAction = (id) => {
  return commonGet(formatUrl(SpcSerUrl.riskSourceDetailUrl, { id }));
};

export const fetchRiskTypeEumAction = () =>{
  return commonGet(SpcSerUrl.riskTypeEumUrl);
};

export const addDangerFactorAction = (body)=>{
  return commonPost(SpcSerUrl.dangerFactorSaveUrl,body);
};

export const deleteDangerFactorAction = (ids) =>{
  return commonDelete(formatUrl(SpcSerUrl.dangerFactorDeleteUrl,{ ids }));
};

export const getFactorDetailAction = (id) =>{
  return commonGet(formatUrl(SpcSerUrl.dangerFactorDetailUrl,{ id }));
};

export const getRiskSourceByTypeAction = (type) =>{
  return commonGet(formatUrl(SpcSerUrl.riskSourceUrl ,{ type }));
};

export const getUserDataAction = ()=>{
  return commonGet(SpcSerUrl.userDataUrl);
};

export const getMethodDataAction = ()=>{
  return commonGet(SpcSerUrl.methodDataUrl);
};

// export const getAreaDataAction = ()=>{
//   return commonGet(SpcSerUrl.areaDataUrl);
// };

export const getEquipmentOptionsDataAction = (param) => {
  let url;
  if (param.workshopSection && param.controlObjectName) {
    url = formatUrl(SpcSerUrl.getEquipmentCodeOptionsUrl, param);
  } else if (param.workshopSection && !param.controlObjectName) {
    url = formatUrl(SpcSerUrl.getEquipmentNameOptionsUrl, param);
  } else if (!param.workshopSection && !param.controlObjectName) {
    url = formatUrl(SpcSerUrl.getEquipmentRegionOptionsUrl, param);
  }
  return commonPost(url);
};

// export const getDeptDataAction = ()=>{
//   return commonGet(SpcSerUrl.deptDataUrl);
// };

// export const getStepDataAction = ()=>{
//   return commonGet(SpcSerUrl.stepDataUrl);
// };

export const getEquipDataAction = ()=>{
  return commonGet(SpcSerUrl.equipDataUrl);
};

// export const getPositionDataAction = ()=>{
//   return commonGet(SpcSerUrl.positionDataUrl);
// };

export const mgtCtrlEquipDetailAction = (riskFactorId)=>{
  return commonGet(formatUrl(SpcSerUrl.mgtCtrlEquipDetailUrl,{ riskFactorId }));
};

export const getTeamDataAction = ()=>{
  return commonGet(SpcSerUrl.teamDataUrl);
};

export const getControlMeasAction = (riskFactorId, evaluateId)=>{
  return commonGet(formatUrl(SpcSerUrl.controlMeasureUrl,{ riskFactorId, evaluateId }));
};


export const relateEquipMgtCtrlObjAction = (body) =>{
  return commonPost(SpcSerUrl.relateEquipMgtUrl,body);
};

/**
 * 管理作业活动
 * @param {*} body
 */
export const relateTaskworkMgtCtrlObjAction = (body) =>{
  return commonPost(SpcSerUrl.relateTaskworkMgtUrl,body);
};


/*** 风险辨识与评价END */


/*** 设备设施service BEGIN */
export const getEquipFacilitiesAction = (filter, page, size) => {
  return commonPost(formatUrl(SpcSerUrl.equipmentListUrl, { page, size }), filter);
};

export const equipmentFacilitiesSaveAction = (equip) => {
  return commonPost(SpcSerUrl.equipmentOperateUrl, equip);
};


export const getEquipmentDataAction = (id) => {
  return commonGet(formatUrl(SpcSerUrl.spcEuipmentFacilitiesUrl,{ id }));
};

export const equipmentFacilitiesDeleteAction = (ids) => {
  return commonDelete( formatUrl(SpcSerUrl.equipmentODeleteUrl, { ids }));
};

export const getRegionDepartmentTreeAction = () => {
  return commonGet(SpcSerUrl.getRegionDepartmentTreeUrl);
};

export const getTaskworkUnPageAction = (body) => {
  return commonPost(SpcSerUrl.taskworkUnPageListUrl, body);
};


export const getMatchesCamerasDataAction = (equipId) => {
  return commonPost(formatUrl(SpcSerUrl.matchesCamerasUrl,{ equipId }));
};

export const bindCamerasAction = (equipId, cameraIds) => {
  return commonPost(formatUrl(SpcSerUrl.bindCamerasUrl,{ equipId, cameraIds }));
};

export const deleteBindCamerasAction = (equipId, cameraIds) => {
  return commonPost(formatUrl(SpcSerUrl.unBindCamerasUrl,{ equipId, cameraIds }));
};

export const getDepatUserListAction = (deptId) => {
  let url = formatUrl(SpcSerUrl.getDeptUserListUrl, { deptId });
  return commonGet(url);
};

export const getEquipTypeEumDataAction = () => {
  return commonGet(SpcSerUrl.equipTypeEumUrl);
};


/*** 设备设施service END */


/*** 作业活动service BEGIN */
export const getTaskworkDataAction = (filter, page, size) => {
  let url = formatUrl(SpcSerUrl.taskworkListUrl, { page, size });
  return commonPost(url, filter);
};

export const getTaskworkTypeDataAction = () => {
  return commonGet(SpcSerUrl.taskworkTypeUrl);
};

export const saveTaskworkAction = (taskwork) => {
  let url = formatUrl(SpcSerUrl.taskworkSaveUrl);
  return commonPost(url, taskwork);
};

export const deleteTaskworkAction = (taskworkId) => {
  let url = formatUrl(SpcSerUrl.taskworkDeleteUrl, { taskworkId });
  return commonDelete(url);
};

export const getTaskworkDetailAction = (taskworkId) => {
  let url = formatUrl(SpcSerUrl.taskworkDetailGetUrl, { taskworkId });
  return commonGet(url);
};

export const getTaskworkContentDetailAction = (taskworkContentId) => {
  let url = formatUrl(SpcSerUrl.taskworkContentDetailUrl, { taskworkContentId });
  return commonGet(url);
};

export const deleteTaskworkContentAction = (contentId)  => {
  let url = formatUrl(SpcSerUrl.taskworkContentDeleteUrl, { contentId });
  return commonDelete(url);
};
/*** 作业活动service END */

/**
 * 获取公司下的人员树
 */
export const getCompanyUserTreeAction = () => {
  return commonGet(SpcSerUrl.companyUserTreeUrl);
};

/**
 * 获取公司下的人员树 人员id前面添加部门id  (一个人在多个部门会对树显示造成影响)
 */
export const getCompanyUserWithDepartmentTreeAction = () => {
  return commonGet(SpcSerUrl.companyUserWithDepartmentTreeUrl);
};

/*** 危险因素service START */
export const startWorkFlowAction = (riskFactorIds) => {
  let url = formatUrl(SpcSerUrl.startWorkFlowUrl, { riskFactorIds });
  return commonPost(url);
};
/*** 危险因素service END */


/*** 风险清单service START */
export const queryRiskAreaListAction = (filter) => {
  filter.riskType = '02';
  let url = formatUrl(SpcSerUrl.riskSourceListQueryUrl);
  return commonPost(url, filter);
};

export const queryRiskLocationListAction = (filter) => {
  filter.riskType = '03';
  let url = formatUrl(SpcSerUrl.riskSourceListQueryUrl);
  return commonPost(url, filter);
};

export const queryEquipHazardSourceListAction = (filter) => {
  let url = formatUrl(SpcSerUrl.equipHazardSourceListQueryUrl);
  return commonPost(url, filter);
};

export const queryControlObjFactorListAction = (filter) => {
  let url = formatUrl(SpcSerUrl.controlObjFactorListQueryUrl);
  return commonPost(url, filter);
};

export const fetchRiskSourceListAction = (filter, page, size) => {
  let url = formatUrl(SpcSerUrl.riskSourceListUrl, { page, size });
  return commonPost(url, filter);
};
/*** 危险因素service END */

/*** 危险因素service START */
//所有风险等级
export const getRiskLevelAllListAction = () => {
  const url = formatUrl(SpcSerUrl.getRiskLevelAllListUrl);
  return commonGet(url);
};

export const getRiskLevelTreeAction = () => {
  const url = formatUrl(SpcSerUrl.getRiskLevelTreeUrl);
  return commonGet(url);
};
/*** 危险因素service END */

/**3d相关 start */
export const initView3DFromBizAction = (type, orgCode) => {
  const url = formatUrl(SpcSerUrl.view3dInitUrl, { type, orgCode });
  return commonGet(url);
};

/**
 * 获取三维风险点的marker
 * @param {*} type
 * @param {*} orgCode
 */
export const initView3DRiskFromBizAction = (type, orgCode) => {
  const url = formatUrl(SpcSerUrl.view3dRiskInitUrl, { type, orgCode });
  return commonGet(url);
};

export const riskSoureDetail3dAction = (id) => {
  const url = formatUrl(SpcSerUrl.riskSoureDetail3dUrl, { id });
  return commonGet(url);
};

export const dangerDetailAction = (id) => {
  const url = formatUrl(SpcSerUrl.dangerDetail3dUrl, { id });
  return commonGet(url);
};

export const euqipmentDetail3dAction = (id) => {
  const url = formatUrl(SpcSerUrl.euqipmentDetail3dUrl, { id });
  return commonGet(url);
};

export const search3dAction = (filter, type,page, size) => {
  let url = formatUrl(SpcSerUrl.search3dListUrl, { type, page, size });
  return commonPost(url, filter);
};

export const getSelectedOrgInfoAction = (id) => {
  return commonGet(SpcSerUrl.selectedOrgInfoUrl);
};

export const msgAction = (time,type,title,page,size) => {
  return commonGet(formatUrl(SpcSerUrl.msgUrl, { time,type,title,page,size }));
};


/**3d相关 end */

export const regionSelectAction = (body) => {
  let url = formatUrl(SpcSerUrl.regionSelectUrl);
  return commonPost(url, body);
};

export const getCheckListAction = (pageIndex,pageSize,deptId) => {
  return commonGet(formatUrl(SpcSerUrl.checkListUrl, { pageIndex,pageSize,deptId }));
};

export const getDangerListDataAction = (param) => {
  return commonPost(formatUrl(SpcSerUrl.getDangerListDataUrl), param);
};

/**重大危险源api START */
export const queryMajorHazardInstallationListAction = (filter) => {
  let url = formatUrl(SpcSerUrl.majorHazardInstallationListQueryUrl);
  return commonPost(url, filter);
};

export const deleteMajorHazardInstallationAction = (ids) => {
  let url = formatUrl(SpcSerUrl.majorHazardInstallationDeleteUrl, { ids });
  return commonDelete(url);
};

export const addMajorHazardInstallationAction = (majorHazard) => {
  let url = formatUrl(SpcSerUrl.majorHazardInstallationSaveUrl);
  return commonPost(url, majorHazard);
};

export const getMajorHazardDetailAction = (id) => {
  let url = formatUrl(SpcSerUrl.majorHazardInstallationDetailGetUrl, { id });
  return commonGet(url);
};
/**重大危险源api END */
