import { commonGet, commonPost, commonPut, commonDelete, formatUrl } from './../utils/request';
import { secExtUrl, FscSerUrl } from './../consts/urlConsts';

export const extendSystemAction = () => {
  const url = formatUrl(secExtUrl.opSearchMenusUrl, {
    nodeName: '',
    type: 25
  });
  return commonGet(url);
};

export const regionListAction = () => {
  return commonGet(secExtUrl.regionListUrl);
};

export const tellRegionSelectAction = (orgCode) => {
  const url = formatUrl(FscSerUrl.tellRegionSelectUrl, { orgCode });
  return commonPost(url);
};
