import { commonGet, commonPost, commonPut, formatUrl } from '../utils/request';
import { SpcSerUrl, patrolUrls, MonitorUrl } from '../consts/urlConsts';
/**
 * 获取风险点数据
 */
export const getRiskSoureData = (orgCode, floor) => {
  return commonGet(formatUrl(SpcSerUrl.riskSoureFloorDataUrl, { orgCode, floor }));
};

/**
 * 更新风险点三维坐标
 * @param {*} data
 */
export const updateRiskSourePosition3d = (data) => {
  let url = SpcSerUrl.updateRiskSourePosition3dUrl;
  return commonPost(url, data);
};

/**
 * 获取巡检点数据
 * @param {*} orgCode 行政区划编码
 * @param {*} floor 楼层
 */
export const getPointData = (orgCode, floor) => {
  return commonGet(formatUrl(patrolUrls.getPointDataUrl, { orgCode, floor }));
};

/**
 * 更新巡检点三维坐标
 * @param {*} id
 * @param {*} position
 */
export const updatePointPosition3d = (id, position) => {
  return commonGet(formatUrl(patrolUrls.updatePointPosition3dUrl, { id, position }));
};

/**
 * 根据行政编码和楼层获取监控点
 * @param {*} orgCode 行政编码
 * @param {*} floor 楼层
 */
export const getMonitorsByFloor3d = (orgCode, floor) => {
  let url = formatUrl(MonitorUrl.getMonitorsByFloor3dUrl, { floor, orgCode });
  return commonGet(url);
};

/**
 * 更新监控点三维坐标
 * @param {*} data
 */
export const updateMonitorPosition3d = (data) => {
  let url = MonitorUrl.updateMonitorPosition3dUrl;
  return commonPut(url, data);
};
