import React from 'react';
import {
  broadcastAction,
  broadcastTypeListAction
} from 'SERVICES/3dService';
import { Connect } from 'amos-framework';
import DataPaneBasic from './../common/DataPaneBasic';
import DataPaneContent from './../common/DataPaneContent';
import Filter from './Filter';
import GroupListPaginate from './../common/GroupListPaginate';
import { eventTopics } from './../../consts';

const eventConnect = Connect.eventConnect;
/**
 * 播报
 * @class Broadcast
 * @extends {DataPaneBasic}
 */
@eventConnect
class Broadcast extends DataPaneBasic {
  constructor(props) {
    super(props);
    this.state = {
      data: [],
      filter: [],
      typeList: [],
      page: 0,
      pageSize: 10
    };
  }

  componentDidMount(){
    this.onSearch();
    broadcastTypeListAction().then(d => this.setState({ typeList: d || [] }));
    this.props.subscribe(eventTopics.datapane_msg, (topic, data) => {
      console.log('datapane_msg****', data);
      this.onHandleMsg(data);
    });
  }

  onHandleMsg = (data) => {
    this.onSearch();
  }
  /**
   * 点击记录中的一个
   */
  onClick = (item) => {
    window.alert(JSON.stringify(item));
  }

  onSearch = (page) => {
    const { filter, pageSize } = this.state;
    broadcastAction(filter, page || 0, pageSize).then(d => {
      this.list.setData(d, this);
    });
  }

  renderItem = (item) => {
    return (
      <div key={item.id} className={`list-group-item ${item.groupByValue ? 'list-group-first-item' : ''}`}>
        { item.groupByValue && <div className="list-group-start">{item.groupByValue}</div> }
        <div className="broadcast-item" >
          <p>{item.timeStr}</p>
          <p>{item.context}</p>
        </div>
      </div>
    );
  }

  render() {
    const { data, typeList, pageSize } = this.state;
    return (
      <DataPaneContent
        onFilterChange={this.onFilterChange}
        typeList={typeList}
        filter={Filter}
      >
        <GroupListPaginate
          ref={node => this.list = node}
          data={data}
          pageSize={pageSize}
          groupBy={d => String(d.timeStr).split(' ')[0]}
          onChangePage={this.onSearch}
          renderItem={e => this.renderItem(e)}
        />
      </DataPaneContent>
    );
  }
}

export default Broadcast;
