import React from 'react';
import {
  monitorAction
} from 'SERVICES/3dService';
import DataPaneBasic from './../common/DataPaneBasic';
import DataPaneContent from './../common/DataPaneContent';
import Filter from './Filter';
import PaneItem from './../common/PaneItem';
import ListPaginate from './../common/ListPaginate';
/**
 * 监控
 * @class Monitor
 * @extends {DataPaneBasic}
 */
class Monitor extends DataPaneBasic {
  constructor(props) {
    super(props);
    this.state = {
      data: [],
      filter: [],
      page: 0,
      pageSize: 10
    };
  }

  componentDidMount(){
    this.onSearch();
  }
  /**
   * 点击监控中的一个
   */
  onClick = (item) => {

  }

  onSearch = (page) => {
    const { filter, pageSize } = this.state;
    monitorAction(filter, page || 0, pageSize).then(d => {
      this.list.setData(d, this);
    });
  }

  renderItem = (item) => {
    return [
      { name: '视频点', value: 'name' },
      { name: '编号', value: 'code' }
    ];
  }

  render() {
    const { data, pageSize } = this.state;
    return (
      <DataPaneContent
        onFilterChange={this.onFilterChange}
        filter={Filter}
      >
        <ListPaginate
          ref={node => this.list = node}
          data={data}
          pageSize={pageSize}
          onChangePage={this.onSearch}
          renderItem={e => <PaneItem renderItem={this.renderItem} key={e.id} data={e} onClick={this.onClick} />}
        />
      </DataPaneContent>
    );
  }
}

export default Monitor;
