import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row, Col } from 'amos-framework';
import AmosGridTable from './../../../bizview/common/tableComponent/table/AmosGridTable';

const checkListColumns = (self) => {
  return [
    {
      title: '巡检路线',
      dataIndex: 'routeName',
      key: 'routeName',
      width: '20%'
    },
    {
      title: '巡检计划',
      dataIndex: 'planName',
      key: 'planName',
      width: '20%'
    },
    {
      title: '执行部门',
      dataIndex: 'deptName',
      key: 'deptName',
      width: '18%'
    },
    {
      title: '执行人',
      dataIndex: 'userName',
      key: 'userName',
      width: '12%'
    },
    ,
    {
      title: '巡检时间',
      dataIndex: 'checkTime',
      key: 'checkTime',
      width: '20%'
    },
    {
      title: '状态',
      dataIndex: 'status',
      key: 'status',
      width: '10%',
      render: function( text, record, index) {
        return <span><a href="javascript:;" onClick={function() { self.onCheckStatusClick(record)} }>{text}</a></span>;
      }
    }
  ];
};

class RiskContentTable extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedRows: [],
      selectedRowKeys: []
    };
  }


    /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  onCheckStatusClick =(record)=>{
    this.props.onCheckStatusClick(record);
  }
 
  render() {
    const { dataList,fetchData } = this.props;
    return (
      <div>
        <AmosGridTable
        columns={checkListColumns(this)}
        getTableDataAction={()=>{}} 
        callBack={this.reload}  
        isPageable = {false}
        isChecked = {false}
        dataList={dataList}
        /> 
      </div>
    );
  }
}

export default RiskContentTable;
