import { Component } from 'react';
import PropTypes from 'prop-types';
import markerFactory from './markerFactory';

class BasicPoint extends Component {
  static propTypes = {
    children: PropTypes.node
  };
  render() {
    // return <div className="basic-marker-point">{this.props.children}</div>;
    return this.props.children;
  }
}

/**
 * 风险点
 */
export const RiskPoint = markerFactory(BasicPoint,
  {
    markerType: 'riskSource'
  }
);

/**
 * 设备设施
 */
export const EquipmentPoint = markerFactory(BasicPoint,
  {
    markerType: 'equipment'
  }
);

/**
 * 隐患点
 */
export const DangerPoint = markerFactory(BasicPoint,
  {
    markerType: 'danger'
  }
);

/**
 * 重大危险源
 */
export const MajorHazardPoint = markerFactory(BasicPoint,
  {
    markerType: 'majorHazard'
  }
);

/**
 * 作业活动
 */
export const TaskworkPoint = markerFactory(BasicPoint,
  {
    markerType: 'taskWork'
  }
);
