import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { utils } from 'amos-tool';
import { Markers } from 'amos-3d/lib/designer';
import PointDialog from './PointDialog';
import { marker3DIoncMapper } from './../../../consts/imgStatic';


const getIcon = (markerType, level) => {
  return marker3DIoncMapper[`${markerType}_${level}`];
};

const buildMarkerOptions = (markers, markerType, defaultParams = {}) => {
  const result = [];
  if (!utils.isEmpty(markers)){
    markers.forEach(m => {
      const url = getIcon(markerType, m.level);
      let position;
      if (!utils.isArray(m.position)){
        position = Object.values(m.position);
      }
      result.push({
        ...m,
        ...defaultParams,
        key: m.key || m.id,
        url,
        label: m.label,
        position,
        size: 10
      });
    });
  }
  return result;
};

export default function marker3DFactory(WrappedComponent = 'div', options){
  const { markerType, markerParams } = options;
  class MarkerPoints extends Component {

    static propTypes = {
      // marker 显隐
      visible: PropTypes.bool,
      markers: PropTypes.array
    };

    constructor(props) {
      super(props);
      this.markerEvents = {
        click: this.onMarkerClick
        // mouseover: (marker) => {
        //   marker.redraw(this.renderMarkerHover);
        // },
        // mouseout: (marker) => {
        //   marker.redraw(this.renderMarker);
        // }
      };
    }

    onMarkerClick = (marker, e) => {
      this.pdRef.onOpenClick(marker);
    }

    render() {
      const { markers, ...rest } = this.props;
      const result = buildMarkerOptions(markers, markerType, markerParams);
      return (
        <WrappedComponent>
          <Markers
            {...rest}
            markers={result}
            events={this.markerEvents}
          />
          <PointDialog ref={node => this.pdRef = node} />
        </WrappedComponent>
      );
    }
  }

  return MarkerPoints;
}
