/* eslint-disable jsx-a11y/alt-text */
import React from 'react';
import PropTypes from 'prop-types';
import { Progress } from 'amos-framework';

/**
 * 加载提示信息
 * @param {} props 
 */
const LoadingComs = props => {
  const { percent, tip } = props;
  return (
    <div className="obj-loading-coms">
      <img src="/src/assets/3dview/loading.gif" />
      <Progress className="loading-progress" percent={percent} status="success" size="sm" showInfo={false} />
      <div className="loading-tip">{tip}</div>
    </div>
  );
};

LoadingComs.propTypes = {
  percent: PropTypes.number,
  successPercent: PropTypes.number,
  tip: PropTypes.string
};

export default LoadingComs;
