import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connect3D } from 'amos-3d/lib/designer';
import { Connect } from 'amos-framework';
import { ThirdFloorPoint, ThirdFloorPointAlarm, SixthFloorPoint, SixthFloorPointAlarm, XYFloorPoint, XYFloorPointAlarm } from './alarm';

export const eventConnect = Connect.eventConnect;
export const Shuttle = (props) => props.children;

/**
 * 告警Markers
 *
 * @export
 * @class PointsAlarm
 * @extends {Component}
 */
@connect3D
@eventConnect
export class PointsAlarm extends Component {
  constructor(props) {
    super(props);
    this.markerList = {};
  }

  componentDidMount() {
  }

  /**
   * 告警信息点击事件
   *
   * @memberof PointsAlarm
   */
  onAlarmClick = (type, item) => {
    // console.log(type, item);
  }

  /**
   * 点创建完成
   *
   * @memberof PointsPool
   */
  onMarkersCreated = (type, { markersCache }) => {
    this.markerList[type] = markersCache;
    (markersCache || []).forEach(mc => {
      const extData = mc.getExtData();
      // console.log(extData);
    });
  };

  render() {
    const { alarms, ...rest } = this.props;
    return (<Shuttle>
      <ThirdFloorPoint {...rest} markers={alarms.thirdFloor} onAlarmClick={this.onAlarmClick} onCreated={(val) => this.onMarkersCreated('floor_3', val)} />
      <ThirdFloorPointAlarm {...rest} markers={alarms.thirdFloor} onCreated={(val) => this.onMarkersCreated('floor_3_alarm', val)} />
      <SixthFloorPoint {...rest} markers={alarms.sixthFloor} onAlarmClick={this.onAlarmClick} onCreated={(val) => this.onMarkersCreated('floor_6', val)} />
      <SixthFloorPointAlarm {...rest} markers={alarms.sixthFloor} onCreated={(val) => this.onMarkersCreated('floor_6_alarm', val)} />
      <XYFloorPoint {...rest} markers={alarms.xyFloor} onAlarmClick={this.onAlarmClick} onCreated={(val) => this.onMarkersCreated('floor_xy', val)} />
      <XYFloorPointAlarm {...rest} markers={alarms.xyFloor} onCreated={(val) => this.onMarkersCreated('floor_xy_alarm', val)} />
    </Shuttle>);
  }
}

PointsAlarm.propTypes = {
  onAlarmClick: PropTypes.func,
  subscribe: PropTypes.func,
  visible: PropTypes.bool,
  alarms: PropTypes.object
};

export default PointsAlarm;
