/* eslint-disable react/prop-types */
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { utils } from 'amos-tool';
import { Markers } from 'amos-3d';
import AlertMarkerPanel from './AlarmMarkerPanel';
import AlarmMarkerFlicker from './AlarmMarkerFlicker';

export default function markerFactory(WrappedComponent = 'div', options){
  const { markerType } = options;
  class MarkerPoints extends Component {
    static propTypes = {
      visible: PropTypes.bool// marker 显式隐藏
    };

    constructor(props) {
      super(props);
      this.markerEvents = {
        click: this.onMarkerClick,
        dblclick: this.onMarkerDblClick
      };
    }

    componentWillMount = () => {
    }

    /**
     * 标记的点单击事件
     *
     * @memberof MarkerPoints
     */
    onMarkerClick = (marker, e) => {
      clearTimeout(this.time);
    }

    /**
     * 标记的点双击事件
     *
     * @memberof MarkerPoints
     */
    onMarkerDblClick = (marker, e) => {
      clearTimeout(this.time);
    }

    /**
     * 告警信息点击事件
     *
     * @memberof MarkerPoints
     */
    onAlarmClick = (type, item) => {
      // console.log(type, item);
      this.props.onAlarmClick(type, item);
    }

    /**
     * 渲染点标记
     *
     * @memberof MarkerPoints
     */
    renderMarker = (extData) => {
      if (extData.key === 'alarm_data') {
        return <AlertMarkerPanel {...extData} markerType={markerType} onAlarmClick={this.onAlarmClick} />;
      } else {
        return <AlarmMarkerFlicker {...extData} markerType={markerType} />;
      }
    }

    render() {
      return (
        <WrappedComponent>
          <Markers
            {...this.props}
            events={this.markerEvents}
            render={this.renderMarker}
          />
        </WrappedComponent>
      );
    }
  }

  return MarkerPoints;
}
