import { Component } from 'react';
import PropTypes from 'prop-types';
import alarmMarkerFactory from './AlarmMarkerFactory';

/**
 * 告警标记点
 *
 * @class AlarmPoint
 * @extends {Component}
 */
class AlarmPoint extends Component {
  static propTypes = {
    children: PropTypes.node
  };
  render() {
    return this.props.children;
  }
}

/**
 * 三楼告警-面板
 */
export const ThirdFloorPoint = alarmMarkerFactory(AlarmPoint,
  {
    markerType: 'floor_3'
  }
);

/**
 * 三楼告警-闪烁
 */
export const ThirdFloorPointAlarm = alarmMarkerFactory(AlarmPoint,
  {
    markerType: 'floor_3_alarm',
    markerParams: {
      useModel: true,
      objPath: '/threeres/marker-models/yuanhuan.obj',
      mtlPath: '/threeres/marker-models/yuanhuan.mtl'
    }
  }
);

/**
 * 六楼告警
 */
export const SixthFloorPoint = alarmMarkerFactory(AlarmPoint,
  {
    markerType: 'floor_6'
  }
);

/**
 * 六楼告警-闪烁
 */
export const SixthFloorPointAlarm = alarmMarkerFactory(AlarmPoint,
  {
    markerType: 'floor_6_alarm'
  }
);

/**
 * 六楼告警
 */
export const XYFloorPoint = alarmMarkerFactory(AlarmPoint,
  {
    markerType: 'floor_xy'
  }
);

/**
 * 六楼告警-闪烁
 */
export const XYFloorPointAlarm = alarmMarkerFactory(AlarmPoint,
  {
    markerType: 'floor_xy_alarm'
  }
);
