import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import Icon from 'amos-icon';

const margin = 8;
const barimgWidth = 105;
const barWidth = barimgWidth + margin;
const leftRightWidth = 25;
const leftRightALLWidth = (leftRightWidth * 2) + margin;

/**
 * 轮播
 *
 * @class Carousel
 * @extends {Component}
 */
class Carousel extends Component {

  static propTypes = {
    files: PropTypes.array,
    barLength: PropTypes.number
  };

  static defaultProps = {
    files: [],
    barLength: 3
  };

  constructor(props) {
    super(props);
    this.state = {
      activeFile: 1,
      allWidth: 0,
      fillObjs: []
    };
  }

  componentDidMount(){
    this.onInit();
  }

  onInit = () => {
    const { files } = this.props;
    let fillObjs = [files[files.length - 1], ...files, files[0]];
    fillObjs = fillObjs.map((e, index) => {
      let value = index;
      if (index === 0) {
        value = files.length;
      }
      if (index === fillObjs.length - 1) {
        value = 1;
      }
      return { key: index, file: e, value };
    });
    this.setState({ allWidth: this.node.clientWidth, fillObjs, activeFile: 1 });
  }

  onClick = (file) => {
    this.setState({ activeFile: file });
  }

  onLeftClick = () => {
    const { files } = this.props;
    const { activeFile } = this.state;
    this.setState({ activeFile: (activeFile - 1) > 0 ? activeFile - 1 : files.length });
  }

  onRightClick = () => {
    const { files } = this.props;
    const { activeFile } = this.state;
    this.setState({ activeFile: (activeFile + 1) <= files.length ? activeFile + 1 : 1 });
  }

  render() {
    const { files, barLength } = this.props;
    const { activeFile, allWidth, fillObjs } = this.state;
    if (files.length === 1) {
      return (
        <div ref={node=> this.node = node} className="carousel-content">
          <img className="carousel-img" src={files[0]} alt="" />
        </div>
      );
    }
    const carouselBarWidth = files.length < barLength ? barWidth * files.length : barWidth * barLength;
    const carouselBarAllWidth = barWidth * fillObjs.length;
    return (
      <div ref={node=> this.node = node} className="carousel-content">
        <ul className="carousel-inner" style={{ width: `${allWidth * fillObjs.length}px`, left: -allWidth * activeFile }}>
          {
            fillObjs.map(e => (
              <li key={e.key} style={{ width: `${allWidth}px` }} className="carousel-item">
                <img className="carousel-img" src={e.file} alt="" />
              </li>
            ))
          }
        </ul>
        <div className="carousel-indicators" style={{ left: `calc(50% - ${(carouselBarWidth + leftRightALLWidth) / 2}px)` }}>
          <div className="carousel-left-bar" onClick={this.onLeftClick} style={{ width: `${leftRightWidth}px`, marginRight: `${margin}px` }}>
            <Icon icon="left"  />
          </div>
          <div className="carousel-center-bar" style={{ width: `${carouselBarWidth}px` }}>
            <ul className="carousel-bar" style={{ width: `${carouselBarAllWidth}px`, left: -barWidth * (activeFile - 1) }}>
              {
                fillObjs.map(e => (
                  <li
                    key={e.key}
                    style={{ width: `${barimgWidth}px`, marginRight: `${margin}px` }}
                    onClick={()=>this.onClick(e.value)}
                    className={classnames('carousel-bar-item', { 'active': e.value === activeFile })}
                  >
                    <img className="carousel-img" src={e.file} alt="" />
                  </li>
                ))
              }
            </ul>
          </div>
          <div className="carousel-right-bar" onClick={this.onRightClick} style={{ width: `${leftRightWidth}px`, marginLeft: `${margin}px` }}>
            <Icon icon="right" />
          </div>
        </div>
      </div>
    );

  }
}

export default Carousel;
