import React from 'react';
import PropTypes from 'prop-types';
import Icon from 'amos-icon';

const Footer = props => {

  const { footers, onItemClick, activeKey } = props;
  return (
    <div className="common-footer">
      {
        footers.map(f => {
          const cls = activeKey === f.key ? 'common-footer-item common-footer-item-active' : 'common-footer-item';
          return (
            <div key={f.key} className={cls} onClick={(e) => onItemClick(f.key, e)}>
              <Icon icon={f.icon} />
              <p className="footer-item-text">{f.text}</p>
            </div>
          );
        })
      }
    </div>
  );
};

Footer.propTypes = {
  footers: PropTypes.arrayOf(PropTypes.shape({
    key: PropTypes.string,
    icon: PropTypes.string,
    text: PropTypes.string
  })),
  onItemClick: PropTypes.func,
  activeKey: PropTypes.string
};

export default Footer;
