import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Select } from 'amos-framework';
import { SingleQueryEnum } from 'amos-processor/lib/config/queryEnum';
import { DatePicker } from 'amos-antd';
import { getImpEquipmentAction } from 'SERVICES/3dService';

const Option = Select.Option;
/**
 * 检索-过滤栏
 *
 * @class Filter
 * @extends {Component}
 */
class Filter extends Component {

  static propTypes = {
    onFilterChange: PropTypes.func,
    typeList: PropTypes.array
  };

  static defaultProps = {
    typeList: []
  };

  constructor(props) {
    super(props);
    this.state = {
      typeList: []
    };
  }

  componentDidMount() {
    getImpEquipmentAction().then(d => this.setState({ typeList: d || [] }));
  }


  render() {
    const { onFilterChange } = this.props;
    const { typeList } = this.state;
    return (
      <div className="datapane-filter-content">
        <Select
          className="datapane-filter-item datapane-filter-select"
          data={typeList}
          renderOption={item => <Option className="datapane-select-option" value={item.id}>{item.name}</Option>}
          defaultOption={<Option className="datapane-select-option">重点设备</Option>}
          onChange={(e) => onFilterChange('equipmentId', e, SingleQueryEnum.EQUAL)}
        />
        <DatePicker
          className="datapane-filter-item datapane-filter-date"
          placeholder="时间"
          format="YYYY/MM/DD"
          onChange={(e) => onFilterChange('createTime', e._d.getTime(), SingleQueryEnum.EQUAL)}
        />
      </div>
    );
  }
}

export default Filter;
