import React from 'react';
import {
  recordAction,
  recordStatusListAction
} from 'SERVICES/3dService';
import Icon from 'amos-icon';
import DataPaneBasic from './../common/DataPaneBasic';
import DataPaneContent from './../common/DataPaneContent';
import Filter from './Filter';
import PaneItem from './../common/PaneItem';
import ListPaginate from './../common/ListPaginate';

/**
 * 预案
 * @class Plan
 * @extends {DataPaneBasic}
 */
class Plan extends DataPaneBasic {
  constructor(props) {
    super(props);
    this.state = {
      searchName: 'pointName',
      data: [],
      filter: [],
      statusList: [],
      page: 0,
      pageSize: 10
    };
  }

  componentDidMount(){
    this.onSearch();
    recordStatusListAction().then(d => this.setState({ statusList: d || [] }));
  }
  /**
   * 点击记录中的一个
   */
  onClick = (item) => {

  }


  onSearch = (page) => {
    const { filter, pageSize } = this.state;
    recordAction(filter, page || 0, pageSize).then(d => {
      this.list.setData(d, this);
    });
  }

  renderItem = (item) => {
    return [
      { name: '名称', value: 'pointName' },
      { name: '类型', value: 'checkTime' },
      { name: '重点设备', value: 'status' }
    ];
  }

  render() {
    const { searchName, data, statusList, pageSize } = this.state;
    return (
      <DataPaneContent
        onFilterChange={this.onFilterChange}
        statusList={statusList}
        filter={Filter}
        searchName={searchName}
      >
        <ListPaginate
          ref={node => this.list = node}
          data={data}
          pageSize={pageSize}
          onChangePage={this.onSearch}
          renderItem={e => <PaneItem renderItem={this.renderItem} key={e.id} data={e} onClick={this.onClick} />}
        />
      </DataPaneContent>
    );
  }
}

export default Plan;
