import React from 'react';
import BizIcon from '../../../common/icon/BizIcon';

const tips = [
  { key: 'rotate', icon: 'jianpan-xuanzhuan', text: '旋转' },
  { key: 'pan', icon: 'jianpan-pingyi', text: '平移' },
  { key: 'scale', icon: 'jianpan-suofang', text: '缩放' },
  { key: 'reset', icon: 'jianpan-zhongzhi', text: '重置' }
];

const ExplainKeyboard = () => {
  return (
    <ul className="explain-keyboard">
      {
        tips.map(t => {
          return (
            <li key={t.key} className="explain-keyboard-item">
              <BizIcon icon={t.icon} />
              <p>{t.text}</p>
            </li>
          );
        })
      }
    </ul>
  );
};

export default ExplainKeyboard;
