import React from 'react';
import BizIcon from '../../../common/icon/BizIcon';

const tips = [
  { key: 'rotate', icon: 'shubiao-xuanzhuan', text: '旋转' },
  { key: 'pan', icon: 'shubiao-pingyi', text: '平移' },
  { key: 'scale', icon: 'shubiao-suofang', text: '缩放' },
  { key: 'reset', icon: 'shubiao-zhongzhi', text: '重置' }
];

const ExplainMouse = () => {
  return (
    <ul className="explain-mouse">
      {
        tips.map(t => {
          return (
            <li key={t.key} className="explain-mouse-item">
              <BizIcon icon={t.icon} />
              <p>{t.text}</p>
            </li>
          );
        })
      }
    </ul>
  );
};

export default ExplainMouse;
