import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, Modal } from 'amos-framework';
import AmosWebSocket from 'amos-websocket';
import * as endConf from 'amos-processor/lib/config/endconf';
import PilotController from 'amos-viz/lib/board/PilotController';
import SysWsURL, { completeToken } from 'CONSTS/wsUrlConsts';
// import AmosGridTable from './../../../bizview/common/tableComponent/table/AmosGridTable';
import { Table } from 'amos-antd';
import { BarCharts,LineCharts } from 'amos-core';
// import { setPieOption,setLineOption } from './chartData';
import ReactEcharts from 'amos-viz/lib/echarts';
import moment from 'moment';
import { List } from 'amos-framework';
// import Three3dView from './View3D';
// import { eventTopics } from './consts';
// import IndexChart from './indexChart';
import {  middleHeaderAction1 ,getporintAction} from '../../../../../services/3dService';
const chartStyle = {
  width: '100%', height: '100%'
};

const eventConnect = Connect.eventConnect;
const AmosConfig = endConf.AmosConfig;
const enableScreenSaver = AmosConfig.screenSaverConf.enable;
const delayTime = AmosConfig.screenSaverConf.delayTime;
//const totalDatas = [1,2,3,4,5,6];
import { OverFlowText,Tooltip,Pagination } from 'amos-framework';



@eventConnect
class PatrolDetail extends Component {
  
  constructor(props) {
    debugger
    super(props);

    this.state = {
      pageData: [],
      total: 0,//总页数
      currentPage:1,
      dataList1:[],
    };
  }

  calcPageData = (page,dataList) => {
    debugger
    if(dataList){
      const [currentPage, pageSize] = page.split('&'); // 当前页、每页大小
      const cp = currentPage.split('=')[1];
      const size = pageSize.split('=')[1];

      // const {dataList1} = this.state;
      const start = (parseInt(cp) - 1) * parseInt(size);
      const end = start + parseInt(size);
      this.setState({ currentPage: cp});
      // const { dataList } = this.props;
      // this.setState({ dataList1:dataList});

      middleHeaderAction1(start,size,dataList[1],dataList[0]).then(data => {
        if(data!=null){
          this.setState({ pageData: data.date, total: data.num})
        }
      });
    }
  };

  handlePageChange = (page) => {
    const { dataList } = this.props;
    this.calcPageData(page,dataList);
  }

  componentDidMount() {
    const { dataList } = this.props;
    this.calcPageData('currentPage=1&pageSize=5',dataList);
  }

  componentWillReceiveProps(nextProps){
    const { dataList } = nextProps;
    this.calcPageData('currentPage=1&pageSize=5',dataList);
  }

  getOptions = (data) => {
    let seriesData = [
      { value: data.passNum || 0, name:'正常' },
      { value: data.nopassNum || 0, name:'异常' },
      { value: data.overTime || 0, name:'漏检'}
    ];
    return {
      // title : {
      //   text: '业务',
      //   x:'left',
      //   textStyle: {
      //     color:'#58f2f4',
      //     fontSize:10
      //   }
      // },
      tooltip: {
          trigger: 'item',
          formatter: "{b}: {c} ({d}%)"
      },

      color:['#58f2f4','#ff8000','#ff0000'],
      series: [
        {
          name:'检查点',
          type:'pie',
          center:['50%','50%'],//饼图位置
          radius: ['50%', '70%'],//外半径，内半径
          avoidLabelOverlap: false,
          label: {
            normal: {
              show: true,
              position: 'center',
              formatter: function(param) {
                let total = 0;
                seriesData.forEach(e => {
                  total += e.value;
                })
                var view =  total + '\r\n总数';
                return view;
              },
                textStyle: {
                fontSize: 14,
                color: '#FFF'
              },
            },
          },
          labelLine: {
            normal: {
              show: false
            }
          },
          data:seriesData
        }
      ]
    };
  }


go3xq = (id,name,coordinates,floor) => {
  debugger

  
  getporintAction(id).then(data => {
    if(data!=null){

      this.props.markerOnClick1(data.cstype,1,id,name,coordinates,floor,data.pointtype);
    }
  });

 

} 




  getDate = () => {
    let currentDate = new Date();
    let year = currentDate.getFullYear();
    let month = currentDate.getMonth() + 1;
    let date = currentDate.getDate();
    return `${year}-${month}-${date}`;
  }

  render() {
    const { total ,pageData,currentPage} = this.state;


    return (
      <div className="patrolDetailContent chart-content">
        <div className='tieleBox'>
          <div className='title'>
            <span className='titleLeft'>
              <span className='titleIcon' style={{ background: 'url("/src/assets/indexChart/point.png") no-repeat center center/100% 100%' }}></span>
            今日巡检计划执行详情</span>
            <span className='titleRight' onClick={this.props.closePatrol}>X</span>
          </div>
        </div>
         <div className='contentBox'>
          <div className='business patrolItem'>
            <div className='list09'>
            { pageData.map(item => {
              return (
              <div className="list1">
                <div className="list2">
                  <div className="list3">
                    <OverFlowText><p style={{ width: '90%' }}> {item.userId}</p></OverFlowText>
                  </div>
                  <div className="list5">
                    <OverFlowText><p style={{ width: '90%' }}>{item.planName}</p></OverFlowText>
                  </div>
                  <div className="list3">{item.deptName}</div>
                </div>
                <div className="list4"> 未开始：{item.noStartNum}&#12288; 异常：{item.noPassNum} &#12288;正常：{item.passNum} &#12288;漏点：{item.overTimeNum}</div>
                <div className='clearfloat'  >
                  {item.pointReturn.map(f => {
                    if (f.isFinish==='0'){
                      return (
                        <Tooltip className="item" title={ f.name } direction="up" align="middle">
                          <div   onClick={ () => {this.go3xq(f.id,f.name,f.coordinates,f.floor)} }  style={{ width: '17px' ,height: '17px' ,border: '1px solid #fff',margin:'3px' ,float:'left',background:'#CCCCCC' }} ></div>
                        </Tooltip>
                      );
                    } else if(f.isFinish==='1'){
                      return (
                        <Tooltip className="item" title={ f.name } direction="up" align="middle">
                          <div   onClick={ () => {this.go3xq(f.id,f.name,f.coordinates,f.floor)} }  style={{ width: '17px' ,height: '17px' ,border: '1px solid #fff',margin:'3px' ,float:'left',background:'#00FF00' }} ></div>
                        </Tooltip>
                      );
                    } else if(f.isFinish==='2'){
                      return (
                        <Tooltip className="item" title={ f.name } direction="up" align="middle">
                          <div   onClick={ () => {this.go3xq(f.id,f.name,f.coordinates,f.floor)} }  style={{ width: '17px' ,height: '17px' ,border: '1px solid #fff',margin:'3px' ,float:'left',background:'#FFFF33' }} ></div>
                        </Tooltip>
                      );
                    } else{
                      return <Tooltip className="item" title={ f.name } direction="up" align="middle">
                          <div   onClick={ () => {this.go3xq(f.id,f.name,f.coordinates,f.floor)} }  style={{ width: '17px' ,height: '17px' ,border: '1px solid #fff',margin:'3px' ,float:'left',background:'#FF0000' }} ></div>
                        </Tooltip>
                    }
                    })
                  }
                </div>
              </div>
                );
              })
            }
            </div>
              <div className='pagination' style={{marginTop:'15px',marginLeft:'20px'}} >
                <Pagination
                currentPage={1}
                totalPageNum={total}
                pageSize={5}
                maxSeries={3}
                hideJumper={true}
                hideSizeChanger={true}
                hideAssistant={true}
                onChange={this.handlePageChange}
                />
              </div>
          </div>
         </div>
      </div>
    );
  }
}

PatrolDetail.propTypes = {
  subscribe: PropTypes.func,
  trigger: PropTypes.func
};

export default PatrolDetail;
