import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect } from 'amos-framework';
// import { eventTopics } from '../consts';
import ControlItem from './ControlItem';

const eventConnect = Connect.eventConnect;

/**
 * 首页右侧菜单
 *
 * @class BizControlPane
 * @extends {Component}
 */
@eventConnect
class BizControlPane extends Component {

  // onSubItemClick = (item, alreadyActive) => {
  //   this.props.trigger(eventTopics.level_filter_risk, {
  //     markerType: item.type,
  //     pointLevel: item.key,
  //     visible: !alreadyActive
  //   });
  // }

  render() {
    const { controls = [], isActive, onItemClick } = this.props;
    return (
      <div className="control-pane-biz">
        <ul className="control-list">
          {
            controls.map(c => (
              <ControlItem
                {...c}
                key={c.key}
                active={isActive(c.key)}
                onClick={(e) => onItemClick(c, e)}
                onSubItemClick={this.onSubItemClick}
                dotTipNum = {this.props.dotTipNum}
              />))
          }
        </ul>
      </div>
    );
  }
}

BizControlPane.propTypes = {
  controls: PropTypes.arrayOf(PropTypes.shape({
    key: PropTypes.string.isRequired,
    type: PropTypes.string.isRequired,
    icon: PropTypes.string,
    label: PropTypes.string,
    isLine: PropTypes.bool,
    subs: PropTypes.array
  })),
  isActive: PropTypes.func,
  onItemClick: PropTypes.func,
  subscribe: PropTypes.func,
  trigger: PropTypes.func
};

export default BizControlPane;
