import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import moment from 'moment';
import { Row, Col } from 'amos-framework';
import { dynamicRingData3dAction } from '../../../../../services/3dService';
// import './../../../../../../src/styles/view/3dview/fireDetectsytle.scss';


const bodtCxt = [
  { name: '电压', value: '3.3' },
  { name: '重量', value: '21.965' },
  { name: '动作状态', value: '已动作' },
  { name: '喷发状态', value: '未喷发' },
  { name: '产品类型', value: '0' },
  { name: '温度', value: '9.3' }
];

/**
 * 火探设备弹出框
 *
 * @class FireDetect
 * @extends {Component}
 */
class FireDetect extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: []
    };
  }


  componentDidMount() {
    let { dialogId} = this.props;
    this.queryFireDetectDetail(dialogId);
  }

  queryFireDetectDetail = (dialogId) => {
    dynamicRingData3dAction(dialogId).then(data => {
      let otherInfoJson = data.find(e => { return e.equipTempCapabName === '气体称重' }) == undefined ? [] : data.find(e => { return e.equipTempCapabName === '气体称重' }).metricList;
      this.setState({
        data: otherInfoJson != 'null' ? otherInfoJson : [],
      })
    });
  }



  render() {
    
    const data = this.state.data ;

    return (
      <div className="dynamicRingData-info-body">
      <div className='dynamicRingData-MonitorElectricity'>
        <Row className="dynamicRingData-baseInfo-row" >
          {data && data.map(item => {
            return (
              <div>
                <Col span={5} className="colTitle">{item.name}：</Col>
                <Col span={5} className="colValue">{item.value}</Col>
              </div>
            );
          })}
        </Row>
      </div>
      </div>
    );
  }
}

FireDetect.propTypes = {
};

export default FireDetect;
