import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { CONSTS } from 'CONSTS/storageConsts';
import AmosGridTable from '../../../../bizview/common/tableComponent/table/AmosGridTable';
import { riskSoureDetail3dAction } from 'SERVICES/bizService';
import { queryPointItemAllDatas } from '../../../../../services/3dService';

const checkListColumns = self => {
  return [
    {
      title: '危险因素名称',
      dataIndex: 'name',
      key: 'name',
      width: '40%'
    },
    {
      title: '责任人',
      dataIndex: 'type',
      key: 'type',
      width: '20%',
      render: (text, record) => {
        //根据换行符分隔
        let arr = text.split(',');
        let p = document.createElement('span');

        if (arr && arr !== null) {
          arr.map((e, index) => {
            if (0 == index) {
              let grandChildItem = document.createElement('p');
              grandChildItem.innerText = '公司:';
              let font = document.createElement('font');
              font.innerText = e;
              grandChildItem.append(font);
              p.append(grandChildItem);
            }

            if (1 == index) {
              let grandChildItem = document.createElement('p');
              grandChildItem.innerText = '部门:';
              let font = document.createElement('font');
              font.innerText = e;
              grandChildItem.append(font);
              p.append(grandChildItem);
            }

            if (2 == index) {
              let grandChildItem = document.createElement('p');
              grandChildItem.innerText = '班组:';
              let font = document.createElement('font');
              font.innerText = e;
              grandChildItem.append(font);
              p.append(grandChildItem);
            }

            if (3 == index) {
              let grandChildItem = document.createElement('p');
              grandChildItem.innerText = '岗位:';
              let font = document.createElement('font');
              font.innerText = e;
              grandChildItem.append(font);
              p.append(grandChildItem);
            }
          });
          return <div dangerouslySetInnerHTML={{ __html: p.outerHTML }}></div>;
        }
      }
    },
    {
      title: '风险等级',
      dataIndex: 'level',
      key: 'level',
      width: '20%'
    },
    {
      title: '安全管控状态',
      dataIndex: 'controlStatus',
      key: 'controlStatus',
      width: '20%'
    }
  ];
};

export const datamoni = {
  id: 349,
  name: 'XAP-P-EXD-SW01',
  code: '0010020003',
  user: null,
  identificationMethod: null,
  riskLevel: '3级',
  riskType: null,
  riskFactors: [
    {
      id: 57,
      name: '噪音',
      type: ' , , , ',
      level: '3级',
      controlStatus: ''
    },
    {
      id: 58,
      name: '设备故障',
      type: ' , , , ',
      level: '4级',
      controlStatus: null
    }
  ],
  riskFactorsControlMeasures: [
    {
      id: 22,
      label: '测试',
      content: '正文'
    },
    {
      id: 23,
      label: '测试',
      content: '正文'
    },
    {
      id: 24,
      label: '测试',
      content: '正文'
    }
  ],
  dangerDetails: null
};

const deviceData = [
  {
    type: 'device',
    name: '中心机房新风机',
    value: '高湿报警',
    identification: 'qualified',
    factorId: 26
  }
];

const patrolData = [
  {
    type: 'patrol',
    name: 'A02机柜',
    value: '【（2U-14U）750服务器01】工作指示灯',
    identification: 'qualified',
    factorId: 31
  },
  {
    type: 'patrol',
    name: 'A02机柜',
    value: '【（2U-14U）750服务器01】噪声',
    identification: 'qualified',
    factorId: 31
  }
];

/**
 * 风险详情
 *
 * @class RiskSourceDetailModal
 * @extends {Component}
 */
class RiskSourceDetailModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedRows: [],
      selectedRowKeys: [],
      data: {},
      patroList: [],
      deviceList: []
    };
  }

  componentDidMount() {
    const { riskSourceId } = this.props;
    riskSourceId && this.queryRiskSoureDetail(riskSourceId);
  }

  onButtonClick = () => {
    const { id: pointId } = this.state.data;
    const { tirggerTransTopic } = this.props;
    const detailParams = { type: 'risk', detailForw: 'record', dialogId: pointId };
    pointId && tirggerTransTopic && tirggerTransTopic(CONSTS.forward, { details: detailParams, dateTime: Date.now() });
  };

  queryRiskSoureDetail = riskSourceId => {
    riskSoureDetail3dAction(riskSourceId).then(data => {
      this.setState({ data });

      data.riskFactors.map(e => {
        let { patroList, deviceList } = this.state;
        queryPointItemAllDatas(e.id).then(datas => {
          datas.patrol &&
            datas.patrol.map(item => {
              patroList.push(item);
            });

          datas.device &&
            datas.device.map(item => {
              deviceList.push(item);
            });
          this.setState({ patroList: patroList, deviceList: deviceList });
        });
      });
    });
  };
  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  // renderDanger = (danger) => {
  //   return (danger || []).map(item => {
  //     return (<p  >
  //       <span>{item.label} &nbsp;</span>
  //       <span>{item.content}：</span>
  //       <span style={{ color: '#FF0000' }}>管控措施失效</span>
  //     </p>);
  //   });
  // }

  renderDangersPatrol = danger => {
    return (danger || []).map(item => {
      if (item && item.identification === 'unqualified') {
        return (
          <p>
            {' '}
            <font style={{ color: '#FF0000' }}>巡检不合格：</font>
            <span>{item.name} &nbsp;</span>
            <span>{item.value} &nbsp;</span>
          </p>
        );
      }
    });
    // return (danger || []).map(item => {
    //   return (<p > <font style={{ color: '#FF0000' }}>巡检不合格：</font>
    //     <span>{item.name} &nbsp;</span>
    //     <span>{item.value} &nbsp;</span>
    //   </p>);
    // });
  };

  renderDangersDevice = danger => {
    // return (danger || []).map(item => {
    //   return (<p > <font style={{ color: '#FF0000' }}>设备告警：</font>
    //     <span>{item.name} &nbsp;</span>
    //     <span>{item.value} &nbsp;</span>
    //   </p>);
    // });
    return (danger || []).map(item => {
      if (item && item.identification === 'unqualified') {
        return (
          <p>
            {' '}
            <font style={{ color: '#FF0000' }}>设备告警：</font>
            <span>{item.name} &nbsp;</span>
            <span>{item.value} &nbsp;</span>
          </p>
        );
      }
    });
  };

  handledata = (data, patroList, deviceList) => {
    if (data.riskFactors) {
      data.riskFactors.map(e => {
        e.controlStatus = '受控';
      });

      data.riskFactors.map(item => {
        patroList.map(p => {
          if ((item.id === p.factorId && p.identification === 'unqualified')) {
            item.controlStatus = '失效';
          }
        });

        deviceList.map(p => {
          if ((item.id === p.factorId && p.identification === 'unqualified')) {
            item.controlStatus = '失效';
          }
        });
      });
    }

    return data;
  };

  render() {
    let { data = {} } = this.state;
    let { patroList, deviceList } = this.state;
    let newData = this.handledata(data, patroList, deviceList);
    return (
      <div className="risk-warn">
        <div className="risk-source-header">
          <span className="colName">风险编号：</span>
          <span className="colValue">{data.code || ''}</span>
          <span className="colName">风险名称：</span>
          <span className="colValue">{data.name || ''}</span>
          <span className="colName">级别：</span>
          <span className="colValue">{data.riskLevel || ''}</span>
        </div>
        <div className="risk-warn-table">
          <AmosGridTable
            columns={checkListColumns(this)}
            getTableDataAction={() => {}}
            callBack={this.reload}
            isPageable={false}
            isChecked={false}
            dataList={newData.riskFactors || []}
          />
        </div>
        <div className="risk-warn-content">
          <div className="risk-warn-content-header">风险触发原因：巡检不合格/设备告警</div>
          {patroList && this.renderDangersPatrol(patroList)}
          {deviceList && this.renderDangersDevice(deviceList)}
        </div>
      </div>
    );
  }
}

RiskSourceDetailModal.propTypes = {
  riskSourceId: PropTypes.string,
  tirggerTransTopic: PropTypes.func
};

export default RiskSourceDetailModal;
