import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { XJBaseURI } from 'CONSTS/urlConsts';
import imgStatic from 'CONSTS/imgStatic';
import Carousel from './../../common/Carousel';

const transitionTime = 500;

class Picture extends Component {

  static propTypes = {
    markerData: PropTypes.object
  };

  static defaultProps = {
    markerData: {}
  };

  constructor(props) {
    super(props);
    this.state = {
      carouselVisable: false
    };
  }

  componentDidMount() {
    this.timer = setTimeout(() => {
      this.setState({ carouselVisable: true });
    }, transitionTime);
  }

  componentWillUnmount() {
    clearTimeout(this.timer);
  }

  render() {
    const { markerData } = this.props;
    let { photosUrl = [] } = markerData || {};
    let imgs = photosUrl.map(e => e.indexOf('\\') === 0 ? `${XJBaseURI}${e.substr(1,e.length - 1)}` : `${XJBaseURI}${e}`);
    return (
      <div className="point-details-picture">
        { imgs.length > 0 && this.state.carouselVisable && <Carousel files={imgs} />}
        { imgs.length === 0 &&
          <div className="points-details-empty">
            <img src={imgStatic.datapane.smilingFace} alt="" />
            <p>暂无图片</p>
          </div>
        }
      </div>
    );
  }
}

export default Picture;
