import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect } from 'amos-framework';
import { eventTopics } from '../../consts';

const eventConnect = Connect.eventConnect;

/**
 * 监控
 *
 * @class MonitorView
 * @extends {Component}
 */
@eventConnect
class MonitorView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: {},
      waters: [],
      timeCount: 0,
      display: 'none',
      fireResourceData: {
        waterSupply: '35 分'
      }
    };
  }

  componentDidMount() {
    // eslint-disable-next-line react/prop-types
    this.props.subscribe(eventTopics.monitor_view, (topic, data) => {
      if (topic === eventTopics.monitor_view) {
        let { display } = this.state;
        if (display === 'none') {
          this.setState({ display: '' });
        }
      }
    });
  }

  render() {
    let { display, fireResourceData } = this.state;
    return (
      <div className="precontrol-monitor-view" style={{ display }} >
        <div className="monitor-view water-supply">
          <div className="text-icon" />
          <span>持续供水</span>
          <span>{fireResourceData.waterSupply}</span>
        </div>
      </div>
    );
  }
}

MonitorView.propTypes = {
  planStart: PropTypes.bool
};

export default MonitorView;
