import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, Timeline } from 'amos-framework';
import { eventTopics } from '../../consts';

const eventConnect = Connect.eventConnect;
const Item = Timeline.Item;

/**
 * 步骤
 *
 * @class StepView
 * @extends {Component}
 */
@eventConnect
class StepView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      stepName: '',
      nextStepName: '',
      display: 'none'
    };
  }

  componentDidMount() {
    this.props.subscribe(eventTopics.stepArea_view, (topic, content) => {
      const { data } =  content;
      const { stepName, nextStepName } = data;
      this.setState({ stepName, nextStepName, display: '' });
    });
  }

  render() {
    let { stepName, nextStepName, display } = this.state;
    let planEnd = stepName && !nextStepName;
    return (
      <div className="precontrol-step-view" style={{ display }} >
        { !planEnd ?
          (
            <div style={{ height: '100%' }}>
              <Item />
              <Item className="previous-step" dot={<img src={require('../../../../../assets/3dview/prePlan/buzhouqu-dangqianbu.png')} alt="" />}><p>{stepName}</p></Item>
              <Item className="next-step" dot={<img src={require('../../../../../assets/3dview/prePlan/buzhouqu-xiayibu.png')} alt="" />} >{nextStepName}</Item>
            </div>
          )
          :
          (
            <div style={{ height: '100%' }}>
              <Item />
              <Item className="previous-step" dot={<img src={require('../../../../../assets/3dview/prePlan/buzhouqu-dangqianbu.png')} alt="" />}><p>{stepName}</p></Item>
            </div>
          )
        }
      </div>
    );
  }
}

StepView.propTypes = {
  subscribe: PropTypes.func
};

export default StepView;
