import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Popover } from 'amos-framework';
import BizIcon from '../../../common/icon/BizIcon';

/**
 * 层级操作
 *
 * @class LayerOperater
 * @extends {Component}
 */
class LayerOperater extends Component {

  constructor(props) {
    super(props);
    this.state = {
      open: false,
      layerActives: props.defaultSelects
    };
  }

  onLayerItemClick = (item) => {
    this.setState({
      layerActives: item.key
    });
    this.props.onLayerItemClick && this.props.onLayerItemClick(item);
  }

  onVisibleChange = (open) => {
    this.setState({
      open
    });
  }

  isActiveLayer = (key) => {
    const { layerActives } = this.state;
    return layerActives === key;
  }

  renderContent = () => {
    const { layers } = this.props;
    return (
      <ul>
        {
          layers.map(l => {
            const cls = this.isActiveLayer(l.key) ? 'layer-item control-active' : 'layer-item';
            return <li key={l.key} className={cls} onClick={() => this.onLayerItemClick(l)}>{l.displayName}</li>;
          })
        }
      </ul>
    );
  }

  render() {
    const { open } = this.state;
    const { title, icon } = this.props;
    return (
      <Popover
        className="layer-popver"
        triggerMode="click"
        align="top"
        direction="right"
        open={open}
        content={this.renderContent()}
      >
        <div className="control-innate-item" title={title}>
          <BizIcon icon={icon} />
        </div>
      </Popover>
    );
  }
}

LayerOperater.propTypes = {
  title: PropTypes.string,
  icon: PropTypes.string,
  layers: PropTypes.array,
  onLayerItemClick: PropTypes.func,
  defaultSelects: PropTypes.oneOfType([
    PropTypes.arrayOf(PropTypes.string),
    PropTypes.string
  ])
};

export default LayerOperater;
