import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, SidePane } from 'amos-framework';
import { eventTopics } from '../consts';
import { tirggerTransTopic } from '../dataProcessor';
import { CONSTS } from 'CONSTS/storageConsts';

const sidepaneStyles = {
  topArea: {
    left: '50%',
    top: 40,
    transform: 'translateX(-50%)'
  }
};
const eventConnect = Connect.eventConnect;

@eventConnect
class  TopMsg extends Component {
  constructor(props) {
    super(props);
    this.state = {
      showContent: 'none',
      content: ''
    };
  }

  componentDidMount() {
    this.props.subscribe(eventTopics.top_afe_msg, (topic, data) => {
      const { content }  = data;
      this.setState({ content, showContent: 'block' });
      tirggerTransTopic(CONSTS.forward, { details: { type: 'alarmVideoMonitor' }, dateTime: Date.now() });
      this.props.alarmStart();
      setTimeout(() => {
        this.setState({ showContent: 'none' });
      }, 7000);
    });
  }

  render() {
    return (
      <SidePane className="rule-pool-topview" top={false} left={false}  style={sidepaneStyles.topArea}>
        <div className="precontrol-top-view" style={{ display: this.state.showContent }}>
          <div className="top-view-2">
            <div className="text-content-alarm">
              {this.state.content}
            </div>
          </div>
        </div>
      </SidePane>
    );
  }
}

TopMsg.propTypes = {
  alarmStart: PropTypes.func
};

export default TopMsg;
