import React, { Component } from 'react';
import PropTypes from 'prop-types';
import VideoDialog from './VideoDialog';

/**
 * 弹出框
 *
 * @class Dialog
 * @extends {Component}
 */
class Dialog extends Component {
  render() {
    const { visible, ...rest } = this.props;
    if (!visible){
      return null;
    }
    return <VideoDialog {...rest} />;
  }
}

Dialog.propTypes = {
  visible: PropTypes.bool
};

export default Dialog;
