import React, { Component } from 'react';
import { Table } from 'amos-antd';
import { getAlertList } from './../../../../services/pamsTableService';

class AlertTable extends Component {
  constructor(props) {
    super(props);
    this.state = {
      totalPage: 0,
      total: 0,
      current: 1,
      pageSize: 5,
      alertList: []
    };
  }

  componentDidMount() {
    this.querryData();
  }

  /**
   * 获取端口数据
   */
  querryData() {
    getAlertList('/src/_mock/pamsTable/index.json', alertList => {
      this.setState({ alertList });
    });
  }


  /**
   *
   *设置共多少页
   */
  showTotal = (total) => {
    return `共 ${( total % this.state.pageSize) ===0 ? Math.floor((total / this.state.pageSize)) : Math.floor((( total / this.state.pageSize) + 1))} 页`;
  }

  /**
   * 设置当前页事件
   */
  onPaginationChange = (current) => {
    this.setState({ current },this.reload);
  }

  rendColumns = () => {
    return [
      {
        title: '序号',
        dataIndex: 'rownum',
        key: 'rownum',
        width: '2%'
      },
      {
        title: '严重度',
        dataIndex: 'severity',
        key: 'severity',
        width: '5%'
      },
      {
        title: '告警原因',
        dataIndex: 'alertReason',
        key: 'alertReason',
        width: '5%'
      },
      {
        title: '告警IP',
        dataIndex: 'alertIP',
        key: 'alertIP',
        width: '5%'
      },
      {
        title: '告警类别',
        dataIndex: 'alertType',
        key: 'alertType',
        width: '5%'
      },
      {
        title: '告警状态',
        dataIndex: 'alertStatus',
        key: 'alertStatus',
        width: '5%'
      },
      {
        title: '产生时间',
        dataIndex: 'birthTime',
        key: 'birthTime',
        width: '5%'
      },
      {
        title: '持续时间',
        dataIndex: 'onTime',
        key: 'onTime',
        width: '5%'
      },
      {
        title: '确认人',
        dataIndex: 'insurePerson',
        key: 'insurePerson',
        width: '5%'
      },
      {
        title: '清除时间',
        dataIndex: 'clsTime',
        key: 'clsTime',
        width: '5%'
      },
      {
        title: '清除人',
        dataIndex: 'clsPerson',
        key: 'clsPerson',
        width: '5%'
      }
    ];
  };
  render() {
    const {alertList } = this.state;
    let tepmPage = Object.assign({
      size: 'small',
      total: this.state.totals,
      current: this.state.current,
      pageSize: this.state.pageSize,
      //onShowSizeChange: this.onSizeChange,
      onChange: this.onPaginationChange,
      showSizeChanger: 'true',
      pageSizeOptions: [5],
      showTotal: this.showTotal
    },  true);
    return (
      <div style={{width: '78%',height: '100%',marginLeft: '28px'}}>
        <Table
          pagination={tepmPage}
          columns={this.rendColumns()}
          dataSource={alertList} />
      </div>
    );
  }
}

export default AlertTable;
