import React, { Component } from 'react';
import { Table } from 'amos-antd';


const MalfunctionList = [
  { rownum: '1', status: '1111' },
  { rownum: '2', status: '2222' },
  { rownum: '3', status: '3333' },
  { rownum: '4', status: '4444' },
  { rownum: '5', status: '5555' },
  { rownum: '6', status: '6666' }
];
class FanTable extends Component {
  constructor(props) {
    super(props);
    this.state = {
      totalPage: 0,
      total: 0,
      current: 1,
      pageSize: 5
    };
  }

  /**
   *
   *设置共多少页
   */
  showTotal = (total) => {
    return `共 ${( total % this.state.pageSize) ===0 ? Math.floor((total / this.state.pageSize)) : Math.floor((( total / this.state.pageSize) + 1))} 页`;
  }

  /**
   * 设置当前页事件
   */
  onPaginationChange = (current) => {
    this.setState({ current },this.reload);
  }

  rendColumns = () => {
    return [
      {
        title: '序号',
        dataIndex: 'rownum',
        key: 'rownum',
        width: '2%'
      },
      {
        title: '状态',
        dataIndex: 'status',
        key: 'status',
        width: '5%'
      }
    ];
  };

  render() {
    let tepmPage = Object.assign({
      size: 'small',
      total: this.state.totals,
      current: this.state.current,
      pageSize: this.state.pageSize,
      //onShowSizeChange: this.onSizeChange,
      onChange: this.onPaginationChange,
      showSizeChanger: 'true',
      pageSizeOptions: [5],
      showTotal: this.showTotal
    },  false);
    return (
      <div style={{width: '14%',height: '100%',marginLeft: '28px'}}>
        <Table
          pagination={tepmPage}
          columns={this.rendColumns()}
          dataSource={MalfunctionList} />
      </div>
    );
  }
}

export default FanTable;
