import React, { Component } from 'react';
import { Table } from 'amos-antd';
import { getPortList } from './../../../../services/pamsTableService';

class PortTable extends Component {
  constructor(props) {
    super(props);
    this.state = {
      totalPage: 0,
      total: 0,
      current: 1,
      pageSize: 5,
      portList: []
    };
  }

  componentDidMount() {
    this.querryData();
  }

  /**
   * 获取端口数据
   */
  querryData() {
    getPortList('/src/_mock/pamsTable/index.json', portList => {
      this.setState({ portList });
    });
  }

  /**
   *
   *设置共多少页
   */
  showTotal = total => {
    return `共 ${total % this.state.pageSize === 0 ? Math.floor(total / this.state.pageSize) : Math.floor(total / this.state.pageSize + 1)} 页`;
  };

  /**
   * 设置当前页事件
   */
  onPaginationChange = current => {
    this.setState({ current }, this.reload);
  };

  rendColumns = () => {
    return [
      {
        title: '序号',
        dataIndex: 'rownum',
        key: 'rownum',
        width: '2%'
      },
      {
        title: '端口号',
        dataIndex: 'portCode',
        key: 'portCode',
        width: '4.5%'
      },
      {
        title: '类型',
        dataIndex: 'portType',
        key: 'portType',
        width: '4.5%'
      },
      {
        title: '端口别名',
        dataIndex: 'portName',
        key: 'portName',
        width: '4.5%'
      },
      {
        title: '端口从属VLAN',
        dataIndex: 'portVlan',
        key: 'portVlan',
        width: '4.5%'
      },
      {
        title: '端口从属带宽',
        dataIndex: 'portWidth',
        key: 'portWidth',
        width: '4.5%'
      },
      {
        title: '端口状态',
        dataIndex: 'portStatus',
        key: 'portStatus',
        width: '4.5%'
      },
      {
        title: '运行状态',
        dataIndex: 'runStatus',
        key: 'runStatus',
        width: '4.5%'
      },
      {
        title: '进流量',
        dataIndex: 'inFlow',
        key: 'inFlow',
        width: '4.5%'
      },
      {
        title: '出流量',
        dataIndex: 'outFlow',
        key: 'outFlow',
        width: '4.5%'
      }
    ];
  };

  render() {
    const { portList } = this.state;
    let tepmPage = Object.assign(
      {
        size: 'small',
        total: this.state.totals,
        current: this.state.current,
        pageSize: this.state.pageSize,
        pageSizeOptions: [ 5 ],
        //onShowSizeChange: this.onSizeChange,
        onChange: this.onPaginationChange,
        showSizeChanger: 'true',
        showTotal: this.showTotal
      },
      true
    );
    return (
      <div style={{ width: '78%', height: '100%', marginLeft: '28px' }}>
        <Table pagination={tepmPage} columns={this.rendColumns()} dataSource={portList} />
      </div>
    );
  }
}

export default PortTable;
